/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.material;

import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum AArmorMaterial implements ArmorMaterial
{
    ALLTHEMODIUM("allthemodium", 42, new int[]{4, 7, 9, 4}, 85, SoundEvents.f_11679_, 5.0f, 0.5f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ALLTHEMODIUM_INGOT.get()})),
    VIBRANIUM("vibranium", 62, new int[]{6, 9, 11, 6}, 105, SoundEvents.f_11679_, 9.0f, 0.8f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.VIBRANIUM_INGOT.get()})),
    UNOBTAINIUM("unobtainium", 82, new int[]{8, 11, 13, 8}, 125, SoundEvents.f_11679_, 15.0f, 1.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.UNOBTAINIUM_INGOT.get()}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockback;
    private final LazyLoadedValue<Ingredient> repairMaterial;

    private AArmorMaterial(String nameIn, int maxDamageFactorIn, int[] damageReductionAmountsIn, int enchantabilityIn, SoundEvent equipSoundIn, float toughness, float knockback, Supplier<Ingredient> repairMaterialSupplier) {
        this.name = nameIn;
        this.maxDamageFactor = maxDamageFactorIn;
        this.damageReductionAmountArray = damageReductionAmountsIn;
        this.enchantability = enchantabilityIn;
        this.soundEvent = equipSoundIn;
        this.toughness = toughness;
        this.repairMaterial = new LazyLoadedValue(repairMaterialSupplier);
        this.knockback = knockback;
    }

    public int getDurabilityForSlot(EquipmentSlot slotIn) {
        return MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * this.maxDamageFactor;
    }

    public int getDefenseForSlot(EquipmentSlot slotIn) {
        return this.damageReductionAmountArray[slotIn.m_20749_()];
    }

    public int m_266425_(ArmorItem.Type type) {
        return this.getDurabilityForSlot(type.m_266308_());
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.getDefenseForSlot(type.m_266308_());
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockback;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{25, 45, 45, 25};
    }
}

