/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.mehvahdjukaar.amendments.common.LecternEditMenu;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.TextFilter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;

public class ServerBoundSyncLecternBookMessage
implements Message {
    private final List<String> pages;
    private final Optional<String> title;
    private final BlockPos pos;
    private final boolean takeBook;

    public ServerBoundSyncLecternBookMessage(BlockPos pos, List<String> list, Optional<String> optional, boolean takeBook) {
        this.pos = pos;
        this.pages = ImmutableList.copyOf(list);
        this.title = optional;
        this.takeBook = takeBook;
    }

    public ServerBoundSyncLecternBookMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.pages = (List)buffer.m_236838_(FriendlyByteBuf.m_182695_(Lists::newArrayListWithCapacity, (int)200), b -> b.m_130136_(8192));
        this.title = buffer.m_236860_(b -> b.m_130136_(128));
        this.takeBook = buffer.readBoolean();
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_236828_(this.pages, (friendlyByteBuf, string) -> friendlyByteBuf.m_130072_(string, 8192));
        buffer.m_236835_(this.title, (friendlyByteBuf, string) -> friendlyByteBuf.m_130072_(string, 128));
        buffer.writeBoolean(this.takeBook);
    }

    public void handle(ChannelHandler.Context context) {
        LecternBlockEntity be;
        ItemStack book;
        ServerPlayer player = (ServerPlayer)context.getSender();
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof LecternBlockEntity && (book = (be = (LecternBlockEntity)blockEntity).m_59566_()).m_41720_() instanceof WritableBookItem) {
            ArrayList list = Lists.newArrayList();
            Objects.requireNonNull(list);
            this.title.ifPresent(list::add);
            Stream limit = this.pages.stream().limit(100L);
            Objects.requireNonNull(list);
            limit.forEach(list::add);
            Consumer<List> consumer = this.title.isPresent() ? l -> this.signBook(be, player, book, (FilteredText)l.get(0), l.subList(1, l.size())) : l -> this.updateBookContents(be, player, book, (List<FilteredText>)l);
            this.filterTextPacket(player, list, TextFilter::m_5925_).thenAcceptAsync(consumer, (Executor)level.m_7654_());
        }
    }

    private <T, R> CompletableFuture<R> filterTextPacket(ServerPlayer player, T message, BiFunction<TextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(player.m_8967_(), (TextFilter)message).thenApply(object -> {
            if (!player.f_8906_.m_6198_()) {
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private void updateBookContents(LecternBlockEntity be, ServerPlayer player, ItemStack itemstack, List<FilteredText> pages) {
        this.updateBookPages(be, player, pages, UnaryOperator.identity(), itemstack);
    }

    private void signBook(LecternBlockEntity be, ServerPlayer player, ItemStack itemstack, FilteredText title, List<FilteredText> pages) {
        ItemStack newStack = new ItemStack((ItemLike)Items.f_42615_);
        CompoundTag compoundtag = itemstack.m_41783_();
        if (compoundtag != null) {
            newStack.m_41751_(compoundtag.m_6426_());
        }
        newStack.m_41700_("author", (Tag)StringTag.m_129297_((String)player.m_7755_().getString()));
        if (player.m_143387_()) {
            newStack.m_41700_("title", (Tag)StringTag.m_129297_((String)title.m_243113_()));
        } else {
            newStack.m_41700_("filtered_title", (Tag)StringTag.m_129297_((String)title.m_243113_()));
            newStack.m_41700_("title", (Tag)StringTag.m_129297_((String)title.f_215168_()));
        }
        this.updateBookPages(be, player, pages, string -> Component.Serializer.m_130703_((Component)Component.m_237113_((String)string)), newStack);
    }

    private void updateBookPages(LecternBlockEntity be, ServerPlayer player, List<FilteredText> pages, UnaryOperator<String> unaryOperator, ItemStack book) {
        AbstractContainerMenu abstractContainerMenu;
        ListTag listtag = new ListTag();
        if (player.m_143387_()) {
            Stream<StringTag> stringTagStream = pages.stream().map(arg -> StringTag.m_129297_((String)((String)unaryOperator.apply(arg.m_243113_()))));
            Objects.requireNonNull(listtag);
            stringTagStream.forEach(arg_0 -> listtag.add(arg_0));
        } else {
            CompoundTag compoundtag = new CompoundTag();
            int j = pages.size();
            for (int i = 0; i < j; ++i) {
                FilteredText filteredtext = pages.get(i);
                String s = filteredtext.f_215168_();
                listtag.add((Object)StringTag.m_129297_((String)((String)unaryOperator.apply(s))));
                if (!filteredtext.m_215174_()) continue;
                compoundtag.m_128359_(String.valueOf(i), (String)unaryOperator.apply(filteredtext.m_243113_()));
            }
            if (!compoundtag.m_128456_()) {
                book.m_41700_("filtered_pages", (Tag)compoundtag);
            }
        }
        book.m_41700_("pages", (Tag)listtag);
        be.m_59536_(book);
        player.m_9236_().m_7260_(this.pos, be.m_58900_(), be.m_58900_(), 3);
        if (this.takeBook && (abstractContainerMenu = player.f_36096_) instanceof LecternEditMenu) {
            LecternEditMenu m = (LecternEditMenu)abstractContainerMenu;
            m.m_6366_((Player)player, 3);
        }
    }
}

