/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.block.AEBaseBlock;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.decorative.solid.BuddingCertusQuartzBlock;
import appeng.decorative.solid.CertusQuartzClusterBlock;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.Fallout;
import appeng.worldgen.meteorite.fallout.FalloutCopy;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import appeng.worldgen.meteorite.fallout.FalloutSand;
import appeng.worldgen.meteorite.fallout.FalloutSnow;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public final class MeteoritePlacer {
    private final BlockState skyStone;
    private final List<BlockState> quartzBlocks;
    private final List<BlockState> quartzBuds;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private final LevelAccessor level;
    private final RandomSource random;
    private final Fallout type;
    private final BlockPos pos;
    private final int x;
    private final int y;
    private final int z;
    private final double meteoriteSize;
    private final double squaredMeteoriteSize;
    private final double crater;
    private final boolean placeCrater;
    private final CraterType craterType;
    private final boolean pureCrater;
    private final boolean craterLake;
    private final BoundingBox boundingBox;

    public static void place(LevelAccessor level, PlacedMeteoriteSettings settings, BoundingBox boundingBox, RandomSource random) {
        MeteoritePlacer placer = new MeteoritePlacer(level, settings, boundingBox, random);
        placer.place();
    }

    private MeteoritePlacer(LevelAccessor level, PlacedMeteoriteSettings settings, BoundingBox boundingBox, RandomSource random) {
        this.boundingBox = boundingBox;
        this.level = level;
        this.random = random;
        this.pos = settings.getPos();
        this.x = settings.getPos().m_123341_();
        this.y = settings.getPos().m_123342_();
        this.z = settings.getPos().m_123343_();
        this.meteoriteSize = settings.getMeteoriteRadius();
        this.placeCrater = settings.shouldPlaceCrater();
        this.craterType = settings.getCraterType();
        this.pureCrater = settings.isPureCrater();
        this.craterLake = settings.isCraterLake();
        this.squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
        double realCrater = this.meteoriteSize * 2.0 + 5.0;
        this.crater = realCrater * realCrater;
        this.quartzBlocks = this.getQuartzBudList();
        this.quartzBuds = Stream.of(AEBlocks.SMALL_QUARTZ_BUD, AEBlocks.MEDIUM_QUARTZ_BUD, AEBlocks.LARGE_QUARTZ_BUD).map(def -> ((CertusQuartzClusterBlock)def.block()).m_49966_()).toList();
        this.skyStone = AEBlocks.SKY_STONE_BLOCK.block().m_49966_();
        this.type = this.getFallout(level, settings.getPos(), settings.getFallout());
    }

    private List<BlockState> getQuartzBudList() {
        if (AEConfig.instance().isSpawnFlawlessOnlyEnabled()) {
            return Stream.of(AEBlocks.FLAWLESS_BUDDING_QUARTZ).map(def -> ((BuddingCertusQuartzBlock)def.block()).m_49966_()).toList();
        }
        return Stream.of(AEBlocks.QUARTZ_BLOCK, AEBlocks.DAMAGED_BUDDING_QUARTZ, AEBlocks.CHIPPED_BUDDING_QUARTZ, AEBlocks.FLAWED_BUDDING_QUARTZ, AEBlocks.FLAWLESS_BUDDING_QUARTZ).map(def -> ((AEBaseBlock)def.block()).m_49966_()).toList();
    }

    public void place() {
        if (this.placeCrater) {
            this.placeCrater();
        }
        this.placeMeteorite();
        if (this.placeCrater) {
            this.decay();
        }
        if (this.craterLake) {
            this.placeCraterLake();
        }
    }

    private int minX(int x) {
        if (x < this.boundingBox.m_162395_()) {
            return this.boundingBox.m_162395_();
        }
        if (x > this.boundingBox.m_162399_()) {
            return this.boundingBox.m_162399_();
        }
        return x;
    }

    private int minZ(int x) {
        if (x < this.boundingBox.m_162398_()) {
            return this.boundingBox.m_162398_();
        }
        if (x > this.boundingBox.m_162401_()) {
            return this.boundingBox.m_162401_();
        }
        return x;
    }

    private int maxX(int x) {
        if (x < this.boundingBox.m_162395_()) {
            return this.boundingBox.m_162395_();
        }
        if (x > this.boundingBox.m_162399_()) {
            return this.boundingBox.m_162399_();
        }
        return x;
    }

    private int maxZ(int x) {
        if (x < this.boundingBox.m_162398_()) {
            return this.boundingBox.m_162398_();
        }
        if (x > this.boundingBox.m_162401_()) {
            return this.boundingBox.m_162401_();
        }
        return x;
    }

    private void placeCrater() {
        int maxY = 255;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        BlockState filler = this.craterType.getFiller().m_49966_();
        for (int j = this.y - 5; j <= 255; ++j) {
            blockPos.m_142448_(j);
            for (int i = this.boundingBox.m_162395_(); i <= this.boundingBox.m_162399_(); ++i) {
                blockPos.m_142451_(i);
                for (int k = this.boundingBox.m_162398_(); k <= this.boundingBox.m_162401_(); ++k) {
                    blockPos.m_142443_(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02)) continue;
                    BlockState currentBlock = this.level.m_8055_((BlockPos)blockPos);
                    if (this.craterType != CraterType.NORMAL && j < this.y && currentBlock.m_280296_()) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(this.level, (BlockPos)blockPos, filler);
                        continue;
                    }
                    this.putter.put(this.level, (BlockPos)blockPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
        for (ItemEntity e : this.level.m_45976_(ItemEntity.class, new AABB((double)this.minX(this.x - 30), (double)(this.y - 5), (double)this.minZ(this.z - 30), (double)this.maxX(this.x + 30), (double)(this.y + 30), (double)this.maxZ(this.z + 30)))) {
            e.m_146870_();
        }
    }

    private void placeMeteorite() {
        this.placeMeteoriteSkyStone();
        if (this.boundingBox.m_71051_((Vec3i)this.pos)) {
            this.placeChest();
        }
    }

    private void placeChest() {
        if (AEConfig.instance().isSpawnPressesInMeteoritesEnabled()) {
            this.putter.put(this.level, this.pos, AEBlocks.MYSTERIOUS_CUBE.block().m_49966_());
        }
    }

    private void placeMeteoriteSkyStone() {
        int meteorXLength = this.minX(this.x - 8);
        int meteorXHeight = this.maxX(this.x + 8);
        int meteorZLength = this.minZ(this.z - 8);
        int meteorZHeight = this.maxZ(this.z + 8);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            pos.m_142451_(i);
            for (int j = this.y - 8; j < this.y + 8; ++j) {
                pos.m_142448_(j);
                for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                    pos.m_142443_(k);
                    int dx = i - this.x;
                    int dy = j - this.y;
                    int dz = k - this.z;
                    double d = (double)(dx * dx) * 0.7;
                    double d2 = dy * dy;
                    double d3 = j > this.y ? 1.4 : 0.8;
                    if (!(d + d2 * d3 + (double)(dz * dz) * 0.7 < this.squaredMeteoriteSize)) continue;
                    if (Math.abs(dx) <= 1 && Math.abs(dy) <= 1 && Math.abs(dz) <= 1) {
                        if (dy != -1) continue;
                        int certusIndex = this.random.m_188503_(this.quartzBlocks.size());
                        this.putter.put(this.level, (BlockPos)pos, this.quartzBlocks.get(certusIndex));
                        if (certusIndex == 0 || dx == 0 && dz == 0 || !((double)this.random.m_188501_() <= 0.7)) continue;
                        BlockState bud = (BlockState)Util.m_214621_(this.quartzBuds, (RandomSource)this.random);
                        BlockState budState = (BlockState)bud.m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)Direction.UP);
                        this.putter.put(this.level, pos.m_7918_(0, 1, 0), budState);
                        continue;
                    }
                    this.putter.put(this.level, (BlockPos)pos, this.skyStone);
                }
            }
        }
    }

    private void decay() {
        double randomShit = 0.0;
        int meteorXLength = this.minX(this.x - 30);
        int meteorXHeight = this.maxX(this.x + 30);
        int meteorZLength = this.minZ(this.z - 30);
        int meteorZHeight = this.maxZ(this.z + 30);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockPosUp = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockPosDown = new BlockPos.MutableBlockPos();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            blockPos.m_142451_(i);
            blockPosUp.m_142451_(i);
            blockPosDown.m_142451_(i);
            for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                blockPos.m_142443_(k);
                blockPosUp.m_142443_(k);
                blockPosDown.m_142443_(k);
                for (int j = this.y - 9; j < this.y + 30; ++j) {
                    double dz;
                    double dy;
                    blockPos.m_142448_(j);
                    blockPosUp.m_142448_(j + 1);
                    blockPosDown.m_142448_(j - 1);
                    BlockState state = this.level.m_8055_((BlockPos)blockPos);
                    Block blk = this.level.m_8055_((BlockPos)blockPos).m_60734_();
                    if (this.pureCrater && blk == this.craterType.getFiller()) continue;
                    if (state.m_247087_()) {
                        if (!this.level.m_46859_((BlockPos)blockPosUp)) {
                            BlockState stateUp = this.level.m_8055_((BlockPos)blockPosUp);
                            this.level.m_7731_((BlockPos)blockPos, stateUp, 3);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crater)) continue;
                        double dx = i - this.x;
                        dy = j - this.y;
                        dz = k - this.z;
                        double dist = dx * dx + dy * dy + dz * dz;
                        BlockState xf = this.level.m_8055_((BlockPos)blockPosDown);
                        if (xf.m_247087_()) continue;
                        double extraRange = this.random.m_188500_() * 0.6;
                        double height = this.crater * (extraRange + 0.2) - Math.abs(dist - this.crater * 1.7);
                        if (xf.m_60795_() || !(height > 0.0) || !(this.random.m_188500_() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(this.level, (BlockPos)blockPos);
                        continue;
                    }
                    if (!this.level.m_46859_((BlockPos)blockPosUp) || !(this.random.m_188500_() > 0.4)) continue;
                    double dx = i - this.x;
                    dy = j - this.y;
                    dz = k - this.z;
                    double dr2 = dx * dx + dy * dy + dz * dz;
                    if (Math.abs(dx) <= 1.0 && Math.abs(dy) <= 1.0 && Math.abs(dz) <= 1.0 || !(dr2 < this.crater * 1.6)) continue;
                    this.type.getRandomInset(this.level, (BlockPos)blockPos);
                }
            }
        }
    }

    private void placeCraterLake() {
        int maxY = this.level.m_5736_() - 1;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int j = this.y - 5; j <= maxY; ++j) {
            blockPos.m_142448_(j);
            for (int i = this.boundingBox.m_162395_(); i <= this.boundingBox.m_162399_(); ++i) {
                blockPos.m_142451_(i);
                for (int k = this.boundingBox.m_162398_(); k <= this.boundingBox.m_162401_(); ++k) {
                    BlockState currentBlock;
                    blockPos.m_142443_(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02) || (currentBlock = this.level.m_8055_((BlockPos)blockPos)).m_60734_() != Blocks.f_50016_) continue;
                    this.putter.put(this.level, (BlockPos)blockPos, Blocks.f_49990_.m_49966_());
                }
            }
        }
    }

    private Fallout getFallout(LevelAccessor level, BlockPos pos, FalloutMode mode) {
        return switch (mode) {
            case FalloutMode.SAND -> new FalloutSand(level, pos, this.putter, this.skyStone, this.random);
            case FalloutMode.TERRACOTTA -> new FalloutCopy(level, pos, this.putter, this.skyStone, this.random);
            case FalloutMode.ICE_SNOW -> new FalloutSnow(level, pos, this.putter, this.skyStone, this.random);
            default -> new Fallout(this.putter, this.skyStone, this.random);
        };
    }
}

