/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagicFire
extends BaseFireBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MagicFire(BlockBehaviour.Properties pProperties, float pFireDamage) {
        super(pProperties, pFireDamage);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.FALSE)).m_61124_((Property)EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)SOUTH, (Comparable)Boolean.FALSE)).m_61124_((Property)WEST, (Comparable)Boolean.FALSE)).m_61124_((Property)UP, (Comparable)Boolean.FALSE));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().filter(p_53497_ -> (Integer)p_53497_.m_61143_((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), MagicFire::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_53491_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_53491_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? f_49237_ : voxelshape;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? this.getStateWithAge(pLevel, pCurrentPos, (Integer)pState.m_61143_((Property)AGE)) : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected boolean m_7599_(BlockState pState) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.getStateForPlacement((BlockGetter)pContext.m_43725_(), pContext.m_8083_());
    }

    public BlockState getStateForPlacement(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!this.canCatchFire(pLevel, pPos, Direction.UP) && !blockstate.m_60783_(pLevel, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(pLevel, pPos.m_121945_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        return pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)pLevel, pPos);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_186460_(pPos, (Block)this, MagicFire.getFireTickDelay(pLevel.f_46441_));
        if (pLevel.m_46469_().m_46207_(GameRules.f_46131_)) {
            BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
            boolean fireSourceBelow = blockstate.isFireSource((LevelReader)pLevel, pPos, Direction.UP);
            int age = (Integer)pState.m_61143_((Property)AGE);
            if (!fireSourceBelow && pLevel.m_46471_() && this.isNearRain((Level)pLevel, pPos) && pRandom.m_188501_() < 0.2f + (float)age * 0.03f) {
                pLevel.m_7471_(pPos, false);
                pLevel.m_7471_(pPos, false);
            } else {
                int j = Math.min(7, age + pRandom.m_188503_(3) / 2);
                if (age != j) {
                    pState = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j));
                    pLevel.m_7731_(pPos, pState, 4);
                }
                if (!fireSourceBelow) {
                    if (!this.isValidFireLocation((BlockGetter)pLevel, pPos)) {
                        BlockPos blockpos = pPos.m_7495_();
                        if (!pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) || age > 3) {
                            pLevel.m_7471_(pPos, false);
                        }
                        return;
                    }
                    if (age == 7 && pRandom.m_188503_(4) == 0 && !this.canCatchFire((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP)) {
                        pLevel.m_7471_(pPos, false);
                        return;
                    }
                }
            }
        }
    }

    protected boolean isNearRain(Level pLevel, BlockPos pPos) {
        return pLevel.m_46758_(pPos) || pLevel.m_46758_(pPos.m_122024_()) || pLevel.m_46758_(pPos.m_122029_()) || pLevel.m_46758_(pPos.m_122012_()) || pLevel.m_46758_(pPos.m_122019_());
    }

    private BlockState getStateWithAge(LevelAccessor pLevel, BlockPos pPos, int pAge) {
        BlockState blockstate = MagicFire.m_49245_((BlockGetter)pLevel, pPos);
        return (BlockState)blockstate.m_61124_((Property)AGE, (Comparable)Integer.valueOf(pAge));
    }

    public static BlockState m_49245_(BlockGetter pReader, BlockPos pPos) {
        return BlockRegistry.MAGIC_FIRE.get().getStateForPlacement(pReader, pPos);
    }

    private boolean isValidFireLocation(BlockGetter pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(pLevel, pPos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        pLevel.m_186460_(pPos, (Block)this, MagicFire.getFireTickDelay(pLevel.f_46441_));
    }

    private static int getFireTickDelay(RandomSource pRandom) {
        return 30 + pRandom.m_188503_(10);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.m_8055_(pos).isFlammable(world, pos, face);
    }
}

