/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.part;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.definition.ArsEngConfig;
import gripe._90.arseng.me.key.SourceKeyType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;

public class SourceP2PTunnelPart
extends CapabilityP2PTunnelPart<SourceP2PTunnelPart, IAdvancedSourceTile> {
    private static final P2PModels MODELS = new P2PModels(ArsEnergistique.makeId("part/source_p2p_tunnel"));
    private static final EmptyHandler EMPTY_HANDLER = new EmptyHandler();

    public SourceP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, ArsEngCapabilities.SOURCE_TILE);
        this.inputHandler = new InputHandler();
        this.outputHandler = new OutputHandler();
        this.emptyHandler = EMPTY_HANDLER;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private OutputHandler getOutputHandler() {
        return (OutputHandler)this.outputHandler;
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128405_("source", this.getOutputHandler().bufferSource);
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.getOutputHandler().bufferSource = data.m_128451_("source");
    }

    private class InputHandler
    implements IAdvancedSourceTile {
        private InputHandler() {
        }

        public int getTransferRate() {
            return this.getMaxSource();
        }

        public boolean canAcceptSource() {
            for (SourceP2PTunnelPart output : SourceP2PTunnelPart.this.getOutputs()) {
                if (!output.getOutputHandler().canAcceptLocalSource()) continue;
                return true;
            }
            return false;
        }

        public int getSource() {
            return SourceP2PTunnelPart.this.getOutputStream().map(part -> part.getOutputHandler().getLocalSource()).reduce(0, Integer::sum);
        }

        public int getMaxSource() {
            return SourceP2PTunnelPart.this.getOutputStream().map(part -> part.getOutputHandler().getLocalMaxSource()).reduce(0, Integer::sum);
        }

        public void setMaxSource(int max) {
            throw new UnsupportedOperationException();
        }

        public int setSource(int source) {
            throw new UnsupportedOperationException();
        }

        public int addSource(int source) {
            List<SourceP2PTunnelPart> outputs = SourceP2PTunnelPart.this.getOutputStream().filter(part -> part.getOutputHandler().canAcceptLocalSource()).toList();
            if (outputs.isEmpty()) {
                return 0;
            }
            SourceP2PTunnelPart.this.queueTunnelDrain(PowerUnits.AE, (double)source / 100.0);
            int forEach = source / outputs.size();
            AtomicInteger spill = new AtomicInteger(source % outputs.size());
            AtomicInteger total = new AtomicInteger(0);
            outputs.forEach(output -> total.addAndGet(output.getOutputHandler().addSourceRespectingBuffer(forEach + (spill.getAndDecrement() > 0 ? 1 : 0))));
            return total.get();
        }

        public int removeSource(int source) {
            return 0;
        }

        @Override
        public boolean relayCanTakePower() {
            return false;
        }

        @Override
        public boolean sourcelinksCanProvidePower() {
            return true;
        }
    }

    private class OutputHandler
    implements IAdvancedSourceTile {
        private static final int MAX_BUFFER = (Integer)ArsEngConfig.OUTPUT_P2P_BUFFER.get();
        private int bufferSource = 0;

        private OutputHandler() {
        }

        private boolean canAcceptLocalSource() {
            return this.getLocalSource() < this.getLocalMaxSource();
        }

        private int addSourceRespectingBuffer(int amount) {
            int source = 0;
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = SourceP2PTunnelPart.this.getAdjacentCapability();){
                IAdvancedSourceTile tile = (IAdvancedSourceTile)guard.get();
                if (tile != null && !(tile instanceof EmptyHandler)) {
                    source += tile.addSource(amount);
                    amount = 0;
                }
            }
            this.bufferSource += amount;
            if (this.bufferSource > MAX_BUFFER) {
                this.bufferSource = MAX_BUFFER;
            }
            return source += this.bufferSource;
        }

        private int getLocalSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = SourceP2PTunnelPart.this.getAdjacentCapability();){
                int n = this.bufferSource + ((IAdvancedSourceTile)guard.get()).getSource();
                return n;
            }
        }

        private int getLocalMaxSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = SourceP2PTunnelPart.this.getAdjacentCapability();){
                int n = MAX_BUFFER + ((IAdvancedSourceTile)guard.get()).getMaxSource();
                return n;
            }
        }

        public int getTransferRate() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                IAdvancedSourceTile tile = (IAdvancedSourceTile)input.get();
                int n = tile != SourceP2PTunnelPart.this.emptyHandler ? tile.getTransferRate() : MAX_BUFFER;
                return n;
            }
        }

        public boolean canAcceptSource() {
            return false;
        }

        public int getSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                int n = ((IAdvancedSourceTile)input.get()).getSource() + this.bufferSource;
                return n;
            }
        }

        public int getMaxSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                int n = ((IAdvancedSourceTile)input.get()).getMaxSource() + MAX_BUFFER;
                return n;
            }
        }

        public void setMaxSource(int max) {
            throw new UnsupportedOperationException();
        }

        public int setSource(int source) {
            throw new UnsupportedOperationException();
        }

        public int addSource(int source) {
            return 0;
        }

        public int removeSource(int source) {
            if (this.bufferSource >= source) {
                this.bufferSource -= source;
                return 0;
            }
            this.bufferSource = 0;
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                int result = ((IAdvancedSourceTile)input.get()).removeSource(source);
                SourceP2PTunnelPart.this.queueTunnelDrain(PowerUnits.AE, (double)result / (double)SourceKeyType.TYPE.getAmountPerOperation());
                int n = result;
                return n;
            }
        }

        @Override
        public boolean relayCanTakePower() {
            return true;
        }

        @Override
        public boolean sourcelinksCanProvidePower() {
            return false;
        }
    }

    private static class EmptyHandler
    implements IAdvancedSourceTile {
        private EmptyHandler() {
        }

        public int getTransferRate() {
            return 0;
        }

        public boolean canAcceptSource() {
            return false;
        }

        public int getSource() {
            return 0;
        }

        public int getMaxSource() {
            return 0;
        }

        public void setMaxSource(int max) {
        }

        public int setSource(int source) {
            return 0;
        }

        public int addSource(int source) {
            return 0;
        }

        public int removeSource(int source) {
            return 0;
        }

        @Override
        public boolean relayCanTakePower() {
            return false;
        }

        @Override
        public boolean sourcelinksCanProvidePower() {
            return false;
        }
    }
}

