/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client.deps.jei.classic.turbine;

import java.awt.Color;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineTerminal;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;

public class CoilCategory
implements IRecipeCategory<Recipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation UID = new ResourceLocation("biggerreactors", "classic/turbine_coil");
    public static final RecipeType<Recipe> RECIPE_TYPE = new RecipeType(UID, Recipe.class);

    public CoilCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)TurbineTerminal.INSTANCE));
        this.background = guiHelper.createDrawable(new ResourceLocation("biggerreactors", "textures/jei/common.png"), 0, 6, 144, 34);
    }

    public RecipeType<Recipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.biggerreactors.classic.turbine_coil_block");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 9);
        slot.addItemStack(recipe.getInput());
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Component[] info = new Component[]{Component.m_237110_((String)"jei.biggerreactors.classic.turbine_coil_bonus", (Object[])new Object[]{recipe.getCoilData().bonus}), Component.m_237110_((String)"jei.biggerreactors.classic.turbine_coil_efficiency", (Object[])new Object[]{recipe.getCoilData().efficiency}), Component.m_237110_((String)"jei.biggerreactors.classic.turbine_coil_extraction", (Object[])new Object[]{recipe.getCoilData().extractionRate})};
        guiGraphics.m_280614_(mc.f_91062_, info[0], 80 - mc.f_91062_.m_92852_((FormattedText)info[0]) / 2, 0, Color.BLACK.getRGB(), false);
        guiGraphics.m_280614_(mc.f_91062_, info[1], 80 - mc.f_91062_.m_92852_((FormattedText)info[1]) / 2, 12, Color.BLACK.getRGB(), false);
        guiGraphics.m_280614_(mc.f_91062_, info[2], 80 - mc.f_91062_.m_92852_((FormattedText)info[2]) / 2, 24, Color.BLACK.getRGB(), false);
    }

    public static class Recipe {
        private final ItemStack input;
        private final TurbineCoilRegistry.CoilData coilData;

        public Recipe(ItemStack input, TurbineCoilRegistry.CoilData coilData) {
            this.input = input;
            this.coilData = coilData;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public TurbineCoilRegistry.CoilData getCoilData() {
            return this.coilData;
        }
    }
}

