/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.debug.IDebuggable;
import net.roguelogix.phosphophyllite.serialization.IPhosphophylliteSerializable;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@ParametersAreNonnullByDefault
@NonnullDefault
public interface IReactorSimulation
extends IPhosphophylliteSerializable,
IDebuggable {
    public void tick(boolean var1);

    @Nullable
    public IBattery battery();

    @Nullable
    public ICoolantTank coolantTank();

    public IFuelTank fuelTank();

    @Nullable
    public ControlRod controlRodAt(int var1, int var2);

    public double fertility();

    public double fuelHeat();

    public double stackHeat();

    public double ambientTemperature();

    default public boolean isAsync() {
        return false;
    }

    public static interface IFuelTank {
        public long capacity();

        public long totalStored();

        public long fuel();

        public long waste();

        public long insertFuel(long var1, boolean var3);

        public long insertWaste(long var1, boolean var3);

        public long extractFuel(long var1, boolean var3);

        public long extractWaste(long var1, boolean var3);

        public double burnedLastTick();
    }

    public static interface ICoolantTank {
        public void dumpLiquid();

        public void dumpVapor();

        public long insertLiquid(long var1);

        public long extractLiquid(long var1);

        public long insertVapor(long var1);

        public long extractVapor(long var1);

        public long liquidAmount();

        public long vaporAmount();

        public long perSideCapacity();

        public void setModeratorProperties(ReactorModeratorRegistry.IModeratorProperties var1);

        public void setTransitionProperties(FluidTransitionRegistry.ITransitionProperties var1);

        public long transitionedLastTick();

        public long maxTransitionedLastTick();

        public long rfTransferredLastTick();
    }

    public static interface IBattery {
        public long extract(long var1);

        public long stored();

        public long capacity();

        public long generatedLastTick();
    }

    public static interface ControlRod {
        public double insertion();

        public void setInsertion(double var1);
    }
}

