/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorPowerTap;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.energy.IEnergyTile;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyHandler;
import net.roguelogix.phosphophyllite.multiblock.common.IEventMultiblock;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorPowerTapTile
extends ReactorBaseTile
implements IEnergyTile,
IPhosphophylliteEnergyHandler,
IEventMultiblock.AssemblyStateTransition {
    @RegisterTile(value="reactor_power_tap")
    public static final BlockEntityType.BlockEntitySupplier<ReactorPowerTapTile> SUPPLIER = new RegisterTile.Producer(ReactorPowerTapTile::new);
    private boolean connected = false;
    Direction powerOutputDirection = null;
    LazyOptional<IPhosphophylliteEnergyHandler> thisCap = LazyOptional.of(() -> this);
    LazyOptional<IPhosphophylliteEnergyHandler> outputOptional = LazyOptional.empty();
    IPhosphophylliteEnergyHandler output;

    public ReactorPowerTapTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public LazyOptional<IPhosphophylliteEnergyHandler> energyHandler() {
        return this.thisCap;
    }

    private void setConnected(boolean newState) {
        if (newState != this.connected) {
            this.connected = newState;
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ReactorPowerTap.ConnectionState.CONNECTION_STATE_ENUM_PROPERTY, (Comparable)((Object)(this.connected ? ReactorPowerTap.ConnectionState.CONNECTED : ReactorPowerTap.ConnectionState.DISCONNECTED))), 3);
        }
    }

    public long distributePower(long toDistribute, boolean simulate) {
        if (this.outputOptional.isPresent()) {
            return Math.max(0L, this.output.insertEnergy(toDistribute, simulate));
        }
        return 0L;
    }

    public long insertEnergy(long maxInsert, boolean simulate) {
        return 0L;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (maxExtract <= 0L || this.nullableController() == null || ((ReactorMultiblockController)this.controller()).assemblyState() != IValidatedMultiblock.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
        if (reactorSim == null) {
            return 0L;
        }
        IReactorSimulation.IBattery battery = reactorSim.battery();
        if (battery == null) {
            return 0L;
        }
        long toExtract = battery.stored();
        toExtract = Math.min(maxExtract, toExtract);
        if (!simulate) {
            toExtract = battery.extract(toExtract);
        }
        return toExtract;
    }

    public long energyStored() {
        if (this.nullableController() != null) {
            IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
            if (reactorSim == null) {
                return 0L;
            }
            IReactorSimulation.IBattery battery = reactorSim.battery();
            if (battery == null) {
                return 0L;
            }
            return Math.max(0L, battery.stored());
        }
        return 0L;
    }

    public long maxEnergyStored() {
        if (this.nullableController() != null) {
            IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
            if (reactorSim == null) {
                return 0L;
            }
            IReactorSimulation.IBattery battery = reactorSim.battery();
            if (battery == null) {
                return 0L;
            }
            return Math.max(0L, battery.capacity());
        }
        return 0L;
    }

    public void neighborChanged() {
        this.outputOptional = LazyOptional.empty();
        this.output = null;
        if (this.powerOutputDirection == null) {
            this.setConnected(false);
            return;
        }
        LazyOptional outputCap = this.findEnergyCapability(this.powerOutputDirection);
        this.setConnected(outputCap.isPresent());
        if (this.connected) {
            this.outputOptional = outputCap;
            this.output = (IPhosphophylliteEnergyHandler)this.outputOptional.orElse(null);
        }
    }

    public void onAssemblyStateTransition(IValidatedMultiblock.AssemblyState oldState, IValidatedMultiblock.AssemblyState newState) {
        this.powerOutputDirection = newState == IValidatedMultiblock.AssemblyState.ASSEMBLED ? (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING) : null;
        this.neighborChanged();
    }
}

