/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor2.simulation;

import java.util.List;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.serialization.IPhosphophylliteSerializable;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public interface ReactorSimulation
extends IPhosphophylliteSerializable {
    public void tick();

    public ReactantSystem reactantSystem();

    @Nullable
    public ControlRod controlRodAt(int var1, int var2);

    public double thermalPower();

    public double fuelTemperature();

    public double stackTemperature();

    public double reactivity();

    default public boolean isAsync() {
        return false;
    }

    @Nullable
    public Moderator moderatorAt(int var1, int var2, int var3);

    public double fuelRodArea();

    public double stackCaseArea();

    public static interface ThermalOutput {
        public void accept(HeatBody var1, HeatBody var2);
    }

    public record CrossSection(double scattering, double capture, double fission) {

        static interface Function {
            public CrossSection generate(double var1, double var3);
        }
    }

    public static interface ReactantSystem {
        public long capacity();

        public long totalStored();

        public double reactedLastTick();

        public ReactantTank tankForReactant(IReactant var1);

        public List<ReactantTank> allReactantTanks();

        public static interface IReactant {
            public double thermalMass();

            public CrossSection.Function crossSectionFunction();
        }

        public static interface ReactantTank {
            public long stored();

            public IReactant reactant();
        }
    }

    public static interface ControlRod {
        public double insertion();

        public void setInsertion(double var1);

        public Properties properties();

        public static interface Properties {
        }
    }

    public static interface Moderator {
        public double thermalMass();

        public double heatConductivity();

        public CrossSection.Function crossSectionFunction();
    }
}

