/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.datagen.BG2BlockTags;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.direwolf20.buildinggadgets2.util.modes.Cut;
import com.direwolf20.buildinggadgets2.util.modes.Paste;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GadgetCutPaste
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.CUTPASTEGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.CUTPASTEGADGET_NEWCOST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean sneakPressed;
        super.m_7373_(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        if (GadgetNBT.getPasteReplace(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"buildinggadgets2.voidwarning").m_130940_(ChatFormatting.RED));
        }
        if (sneakPressed = Screen.m_96638_()) {
            // empty if block
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (!mode.getId().m_135815_().equals("cut")) {
            if (mode.getId().m_135815_().equals("paste")) {
                UUID uuid = GadgetNBT.getUUID(gadget);
                if (ServerTickHandler.gadgetWorking(GadgetNBT.getUUID(gadget))) {
                    context.player().m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.cutinprogress"), true);
                    return InteractionResultHolder.m_19098_((Object)gadget);
                }
                BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().m_9236_().m_7654_()).m_129783_());
                ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(uuid, false);
                Collections.reverse(buildList);
                ArrayList<TagPos> tagList = bg2Data.peekTEMap(uuid);
                ArrayList<StatePos> actuallyBuiltList = BuildingUtils.buildWithTileData(context.level(), context.player(), buildList, GadgetCutPaste.getHitPos(context).m_7494_().m_121955_((Vec3i)GadgetNBT.getRelativePaste(gadget)), tagList, gadget);
                if (!actuallyBuiltList.isEmpty()) {
                    GadgetNBT.clearAnchorPos(gadget);
                }
                GadgetNBT.clearCopyUUID(gadget);
                GadgetNBT.setMode(gadget, new Cut());
                return InteractionResultHolder.m_19090_((Object)gadget);
            }
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        GadgetNBT.setCopyStartPos(gadget, context.pos());
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (mode.getId().m_135815_().equals("cut")) {
            GadgetNBT.setCopyEndPos(gadget, context.pos());
        } else if (!mode.equals(new Paste())) {
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    public void cutAndStore(Player player, ItemStack gadget) {
        int maxSize;
        if (ServerTickHandler.gadgetWorking(GadgetNBT.getUUID(gadget))) {
            return;
        }
        ArrayList<StatePos> buildList = new ArrayList<StatePos>();
        ArrayList<TagPos> teData = new ArrayList<TagPos>();
        UUID buildUUID = UUID.randomUUID();
        ItemStack heldItem = BaseGadget.getGadget(player);
        Item item = heldItem.m_41720_();
        if (!(item instanceof GadgetCutPaste)) {
            return;
        }
        GadgetCutPaste gadgetCutPaste = (GadgetCutPaste)item;
        Level level = player.m_9236_();
        BlockPos cutStart = GadgetNBT.getCopyStartPos(heldItem);
        BlockPos cutEnd = GadgetNBT.getCopyEndPos(heldItem);
        if (cutStart.equals((Object)GadgetNBT.nullPos) || cutEnd.equals((Object)GadgetNBT.nullPos)) {
            return;
        }
        AABB area = new AABB(cutStart, cutEnd);
        Stream areaStream = BlockPos.m_121921_((AABB)area);
        long size = areaStream.count();
        if (size > (long)(maxSize = 100000)) {
            player.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.areatoolarge", (Object[])new Object[]{maxSize, size}), false);
            return;
        }
        int totalCost = gadgetCutPaste.getEnergyCost() * (int)size;
        if (!player.m_7500_() && !BuildingUtils.hasEnoughEnergy(heldItem, totalCost)) {
            player.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.notenoughenergy", (Object[])new Object[]{totalCost, BuildingUtils.getEnergyStored(heldItem)}), false);
            return;
        }
        BlockPos.m_121921_((AABB)area).map(BlockPos::m_7949_).sorted(Comparator.comparingInt(Vec3i::m_123342_).reversed()).forEach(pos -> ServerTickHandler.addToMap(buildUUID, new StatePos(Blocks.f_50016_.m_49966_(), (BlockPos)pos), level, GadgetNBT.getRenderTypeByte(gadget), player, false, false, gadget, ServerBuildList.BuildType.CUT, false, BlockPos.f_121853_));
        ServerTickHandler.setCutStart(buildUUID, cutStart);
        GadgetNBT.setCopyStartPos(gadget, GadgetNBT.nullPos);
        GadgetNBT.setCopyEndPos(gadget, GadgetNBT.nullPos);
        player.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.cutblocks", (Object[])new Object[]{size}), true);
        UUID uuid = GadgetNBT.getUUID(gadget);
        GadgetNBT.setCopyUUID(gadget, buildUUID);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(player.m_9236_().m_7654_()).m_129783_());
        bg2Data.addToCopyPaste(uuid, buildList);
        bg2Data.addToTEMap(uuid, teData);
    }

    public static boolean customCutValidation(BlockState blockState, Level level, Player player, BlockPos blockPos) {
        if (blockState.m_204336_(BG2BlockTags.NO_MOVE)) {
            return false;
        }
        return level.m_7966_(player, blockPos);
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.CUTPASTE;
    }
}

