/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen;

import java.util.ArrayList;
import java.util.HexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigUtils;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.SimpleConfigOption;
import terrails.colorfulhearts.config.screen.HeartType;
import terrails.colorfulhearts.config.screen.base.ScrollableWidgetList;
import terrails.colorfulhearts.config.screen.widgets.HeartColorEditBox;
import terrails.colorfulhearts.render.HeartRenderer;
import terrails.colorfulhearts.render.TabHeartRenderer;

public class ColorSelectionScreen
extends Screen {
    private final Screen lastScreen;
    private List<HeartColorEditBox> editBoxes;
    private List<Button> heartTypeButtons;
    private Button saveButton;
    private boolean vanillaHeart;
    private boolean hasChanged;
    private boolean colorsChanged;
    private boolean vanillaChanged;
    private ScrollableWidgetList colorSelectionList;
    private HeartType heartType;

    public ColorSelectionScreen(Screen lastScreen, boolean health) {
        super((Component)Component.m_237115_((String)(health ? "colorfulhearts.screen.health.title" : "colorfulhearts.screen.absorption.title")));
        this.lastScreen = lastScreen;
        this.heartType = health ? HeartType.HEALTH : HeartType.ABSORBING;
        this.updateHeartType(this.heartType, false);
    }

    public void m_86600_() {
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.f_93623_ = false;
            });
            this.saveButton.f_93623_ = this.canApplyChanges();
        } else if (this.saveButton.f_93623_) {
            this.m_232761_();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.colorsChanged = false;
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int marginY = 32;
        double prevScrollAmount = this.colorSelectionList == null ? 0.0 : this.colorSelectionList.m_93517_();
        this.colorSelectionList = (ScrollableWidgetList)this.m_142416_((GuiEventListener)new ScrollableWidgetList(Minecraft.m_91087_(), width, height, marginY, height - marginY, 26));
        this.addColorElements();
        this.colorSelectionList.m_93410_(prevScrollAmount);
        int BUTTON_SPACING = 10;
        int BUTTON_WIDTH = 80;
        int BUTTON_HEIGHT = 20;
        int startX = (width - BUTTON_WIDTH * 4 - BUTTON_SPACING * 3) / 2;
        int y = (marginY - 20) / 2;
        Button normalHearts = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.normal"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH : HeartType.ABSORBING, true)).m_252794_(startX, y).m_253046_(BUTTON_WIDTH, BUTTON_HEIGHT).m_253136_());
        normalHearts.f_93623_ = this.heartType != HeartType.HEALTH && this.heartType != HeartType.ABSORBING;
        int x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        Button poisonedHearts = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.poisoned"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_POISONED : HeartType.ABSORBING_POISONED, true)).m_252794_(x, y).m_253046_(BUTTON_WIDTH, BUTTON_HEIGHT).m_253136_());
        poisonedHearts.f_93623_ = this.heartType != HeartType.HEALTH_POISONED && this.heartType != HeartType.ABSORBING_POISONED;
        Button witheredHearts = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.withered"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_WITHERED : HeartType.ABSORBING_WITHERED, true)).m_252794_(x += BUTTON_WIDTH + BUTTON_SPACING, y).m_253046_(BUTTON_WIDTH, BUTTON_HEIGHT).m_253136_());
        witheredHearts.f_93623_ = this.heartType != HeartType.HEALTH_WITHERED && this.heartType != HeartType.ABSORBING_WITHERED;
        Button frozenHearts = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"colorfulhearts.options.button.hearttype.frozen"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_FROZEN : HeartType.ABSORBING_FROZEN, true)).m_252794_(x += BUTTON_WIDTH + BUTTON_SPACING, y).m_253046_(BUTTON_WIDTH, BUTTON_HEIGHT).m_253136_());
        frozenHearts.f_93623_ = this.heartType != HeartType.HEALTH_FROZEN && this.heartType != HeartType.ABSORBING_FROZEN;
        this.heartTypeButtons = List.of(normalHearts, poisonedHearts, witheredHearts, frozenHearts);
        BUTTON_WIDTH = 120;
        BUTTON_SPACING = 30;
        startX = (width - BUTTON_WIDTH * 2 - BUTTON_SPACING) / 2;
        y = height - BUTTON_HEIGHT / 2 - marginY / 2;
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"colorfulhearts.options.button.confirmsave"), btn -> {
            this.saveConfig();
            this.m_7379_();
        }).m_252794_(startX, y).m_253046_(BUTTON_WIDTH, BUTTON_HEIGHT).m_253136_());
        this.saveButton.f_93623_ = false;
        x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"colorfulhearts.options.button.cancel"), btn -> this.m_7379_()).m_252794_(x, y).m_253046_(BUTTON_WIDTH, BUTTON_HEIGHT).m_253136_());
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.f_93623_ = false;
            });
        }
        if (this.canApplyChanges()) {
            this.saveButton.f_93623_ = true;
        }
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.lastScreen);
        if (this.colorsChanged) {
            this.f_96541_.m_91391_();
            ConfigUtils.loadColoredHearts();
            ConfigUtils.loadStatusEffectHearts();
            HeartRenderer.INSTANCE.lastHealth = 0;
            TabHeartRenderer.INSTANCE.lastHealth = 0;
            CColorfulHearts.PROXY.heartUpdateEvent();
        } else if (this.vanillaChanged) {
            ConfigUtils.loadColoredHearts();
            ConfigUtils.loadStatusEffectHearts();
            HeartRenderer.INSTANCE.lastHealth = 0;
            TabHeartRenderer.INSTANCE.lastHealth = 0;
            CColorfulHearts.PROXY.heartUpdateEvent();
        }
    }

    public void updateHeartType(HeartType type, boolean rebuildWidgets) {
        this.heartType = type;
        this.editBoxes = null;
        boolean bl = this.vanillaHeart = this.hasVanillaVariant() && type.isVanillaVariantPresent();
        if (rebuildWidgets) {
            this.m_232761_();
        }
    }

    public boolean hasVanillaVariant() {
        return this.heartType.isHealthType() || this.heartType == HeartType.ABSORBING;
    }

    private void addColorElements() {
        int ELEMENTS_PER_ROW = 4;
        int ELEMENT_SPACING = 6;
        int EDIT_BOX_WIDTH = 60;
        int BUTTON_DIMS = 20;
        int BUTTON_SPACING = 3;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int totalElementWidth = 350;
        int startX = (screenWidth - totalElementWidth) / 2;
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        int OFFSET = 0;
        if (this.hasVanillaVariant()) {
            OFFSET = 1;
            Supplier<Component> componentSupplier = () -> Component.m_237115_((String)(this.vanillaHeart ? "colorfulhearts.options.button.vanillaheart.true" : "colorfulhearts.options.button.vanillaheart.false"));
            widgets.add((AbstractWidget)Button.m_253074_((Component)componentSupplier.get(), btn -> {
                this.vanillaHeart = !this.vanillaHeart;
                this.hasChanged = this.haveValuesChanged();
                btn.m_93666_((Component)componentSupplier.get());
                this.m_232761_();
            }).m_252794_(startX, 0).m_253046_(83, 20).m_253136_());
        }
        if (this.editBoxes == null) {
            List<Integer> colors = this.heartType.getColors();
            this.editBoxes = new LinkedList<HeartColorEditBox>();
            for (Integer color : colors) {
                if (color == null) continue;
                HeartColorEditBox box = new HeartColorEditBox(this.f_96547_, 0, 0, 0, 0, this.heartType);
                box.m_94144_("#" + HexFormat.of().toHexDigits(color.intValue(), 6));
                this.editBoxes.add(box);
            }
        }
        int elementCount = this.editBoxes.size();
        for (int i = 0; i < elementCount; ++i) {
            boolean canAddMoreHearts;
            boolean stop;
            boolean bl = stop = this.heartType.isHealthType() && this.heartType != HeartType.HEALTH && (i > 0 && this.vanillaHeart || i > 1);
            if (stop) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                break;
            }
            int column = (i + OFFSET) % 4;
            int x = startX + column * 89;
            int i_ = i;
            Button button = Button.m_253074_((Component)Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED), btn -> {
                this.editBoxes.remove(i_);
                this.hasChanged = this.haveValuesChanged();
                this.m_232761_();
            }).m_252794_(x, 0).m_253046_(20, 20).m_253136_();
            HeartColorEditBox box = this.editBoxes.get(i);
            box = new HeartColorEditBox(this.f_96547_, x + 20 + 3, 0, 58, 20, box, this.heartType);
            box.m_94151_(str -> {
                this.hasChanged = this.haveValuesChanged();
            });
            this.editBoxes.set(i, box);
            widgets.add((AbstractWidget)button);
            widgets.add((AbstractWidget)box);
            if (column + 1 == 4) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                widgets.clear();
            }
            if (i + 1 != elementCount) continue;
            boolean bl2 = canAddMoreHearts = !this.heartType.isEffectType() || !this.hasEnoughColors();
            if (canAddMoreHearts) {
                column = (column + 1) % 4;
                x = startX + column * 89;
                Button addButton = Button.m_253074_((Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), btn -> {
                    this.editBoxes.add(new HeartColorEditBox(this.f_96547_, 0, 0, 38, 20, this.heartType));
                    this.hasChanged = this.haveValuesChanged();
                    this.m_232761_();
                }).m_252794_(x, 0).m_253046_(20, 20).m_253136_();
                widgets.add((AbstractWidget)addButton);
            }
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
        if (this.editBoxes.isEmpty()) {
            int x = startX + 60 + 20 + 6 + 3;
            Button addButton = Button.m_253074_((Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), btn -> {
                this.editBoxes.add(new HeartColorEditBox(this.f_96547_, 0, 0, 38, 20, this.heartType));
                this.m_232761_();
            }).m_252794_(x, 0).m_253046_(20, 20).m_253136_();
            widgets.add((AbstractWidget)addButton);
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
    }

    public boolean hasEnoughColors() {
        int count = this.editBoxes.size();
        return count > 0 && this.heartType.isHealthType() && (this.heartType == HeartType.HEALTH || this.vanillaHeart || count == 2) || !this.heartType.isHealthType() && (this.heartType == HeartType.ABSORBING || count == 2);
    }

    public boolean canApplyChanges() {
        if (this.editBoxes.stream().anyMatch(HeartColorEditBox::isInvalidHex)) {
            return false;
        }
        return this.hasChanged && this.hasEnoughColors();
    }

    private boolean haveValuesChanged() {
        if (this.editBoxes.stream().anyMatch(HeartColorEditBox::isInvalidHex)) {
            return true;
        }
        if (this.vanillaHeart != this.heartType.isVanillaVariantPresent()) {
            return true;
        }
        List<Integer> currentColors = this.heartType.getColors();
        List<Integer> newColors = this.editBoxes.stream().map(HeartColorEditBox::getColor).toList();
        if (currentColors.size() != newColors.size()) {
            return true;
        }
        for (int i = 0; i < currentColors.size(); ++i) {
            if (Objects.equals(currentColors.get(i), newColors.get(i))) continue;
            return true;
        }
        return false;
    }

    private SimpleConfigOption<Boolean> getConfigVanilla() {
        return switch (this.heartType) {
            case HeartType.HEALTH -> Configuration.HEALTH.vanillaHearts;
            case HeartType.ABSORBING -> Configuration.ABSORPTION.vanillaHearts;
            default -> null;
        };
    }

    private void saveConfig() {
        SimpleConfigOption<Boolean> configVanilla = this.getConfigVanilla();
        if (configVanilla != null && this.vanillaHeart != configVanilla.get()) {
            configVanilla.set(this.vanillaHeart);
            this.vanillaChanged = true;
        }
        SimpleConfigOption<List<String>> configColors = this.heartType.getRawColors();
        List<String> currentColors = configColors.get().stream().map(String::toUpperCase).toList();
        List<String> newColors = this.editBoxes.stream().map(HeartColorEditBox::getColor).map(i -> "#" + HexFormat.of().toHexDigits(i.intValue(), 6).toUpperCase()).toList();
        if (currentColors.size() != newColors.size()) {
            configColors.set(newColors);
            this.colorsChanged = true;
        } else {
            for (int i2 = 0; i2 < currentColors.size(); ++i2) {
                if (Objects.equals(currentColors.get(i2), newColors.get(i2))) continue;
                configColors.set(newColors);
                this.colorsChanged = true;
                break;
            }
        }
        CColorfulHearts.PROXY.applyConfig();
    }
}

