/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.reflect.Type;

public class ByteBufferTypeHandler<T>
implements JsonSerializer<ByteBuf>,
JsonDeserializer<ByteBuf> {
    private static final double HUMA_READABLE_THRESHOLD = 3.0;

    public ByteBuf deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return null;
    }

    public JsonElement serialize(ByteBuf src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray result = new JsonArray();
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            JsonElement element = context.serialize((Object)"Enable debugPrintMessages to display this data");
            result.add(element);
        } else {
            String data = this.cleanupString(src.toString(Charsets.UTF_8)) + "\n";
            double entropy = ByteBufferTypeHandler.calculateEntropy(data);
            if (entropy > 3.0) {
                JsonElement element = context.serialize((Object)this.cleanupString(data));
                result.add(element);
            } else {
                result.add("<partial numeric data>");
                StringBuilder arrayString = new StringBuilder();
                arrayString.append("[");
                byte[] byteData = ByteBufUtil.getBytes((ByteBuf)src, (int)0, (int)(src.readableBytes() + src.readerIndex()));
                for (int i = 0; i < byteData.length && i < 200; ++i) {
                    arrayString.append(byteData[i]);
                    if (i >= byteData.length - 1) continue;
                    arrayString.append(", ");
                }
                arrayString.append("]");
                result.add(arrayString.toString());
            }
        }
        return result;
    }

    public static double calculateEntropy(String input) {
        Int2IntOpenHashMap map = new Int2IntOpenHashMap();
        for (char c : input.toCharArray()) {
            map.put((int)c, map.get((int)c) + 1);
        }
        double entropy = 0.0;
        IntIterator intIterator = map.values().iterator();
        while (intIterator.hasNext()) {
            int count = (Integer)intIterator.next();
            if (count <= 0) continue;
            double probability = (double)count / (double)input.length();
            entropy -= probability * (Math.log(probability) / Math.log(2.0));
        }
        return entropy;
    }

    private String cleanupString(String input) {
        StringBuilder readableText = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (c < ' ' || c > '~') continue;
            readableText.append(c);
        }
        return readableText.toString();
    }
}

