/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.joml.Quaternionf;
import tfar.craftingstation.Configs;
import tfar.craftingstation.CraftingStationBlock;
import tfar.craftingstation.CraftingStationBlockEntity;

public class CraftingStationBlockEntityRenderer
implements BlockEntityRenderer<CraftingStationBlockEntity> {
    private float _blockScale = 0.25f;
    private float _itemScale = 0.125f;

    public CraftingStationBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CraftingStationBlockEntity blockEntity, float var2, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int light, int var6) {
        if (!((Boolean)Configs.Client.showItemsInTable.get()).booleanValue() || blockEntity.input.isEmpty()) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        double height = state.m_61138_((Property)SlabBlock.f_56353_) ? (state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM ? 0.5 : 1.0) : 1.0;
        double spacing = 0.189;
        double offset = 0.31;
        matrixStack.m_85837_(0.0, 0.0625 + height, 0.0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack item = blockEntity.input.getStackInSlot(j + 3 * i);
                if (item.m_41619_()) continue;
                boolean isItem = !(item.m_41720_() instanceof BlockItem);
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_252781_(new Quaternionf().rotationY((float)this.getRotation((Direction)state.m_61143_((Property)CraftingStationBlock.FACING)) * ((float)Math.PI / 180)));
                matrixStack.m_85837_(-0.5, -0.5, -0.5);
                matrixStack.m_85837_(0.189 * (double)i + 0.31, isItem ? -0.05 : 0.0, 0.189 * (double)(2 - j) + 0.31);
                matrixStack.m_252781_(new Quaternionf().rotationY(4.712389f));
                float scale = isItem ? this._itemScale : this._blockScale;
                matrixStack.m_85841_(scale, scale, scale);
                if (isItem) {
                    matrixStack.m_252781_(new Quaternionf().rotationX(1.5707964f));
                }
                BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(item, blockEntity.m_58904_(), null, 0);
                int lightAbove = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_7494_());
                Minecraft.m_91087_().m_91291_().m_115143_(item, ItemDisplayContext.FIXED, false, matrixStack, iRenderTypeBuffer, lightAbove, OverlayTexture.f_118083_, bakedmodel);
                matrixStack.m_85849_();
            }
        }
    }

    private int getRotation(Direction dir) {
        switch (dir) {
            case NORTH: {
                return 270;
            }
            case EAST: {
                return 180;
            }
            case SOUTH: {
                return 90;
            }
            case WEST: {
                return 0;
            }
        }
        return 0;
    }
}

