/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperInfusionHandler;

public class TypeInfusion {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismInfusion.get()).booleanValue() && IInfusionHandler.class != null) {
            HandlerRegistry.register(Capabilities.INFUSION_HANDLER, InfusionTankHandler.Provider.INSTANCE);
        }
    }

    public static class InfusionTankHandler
    implements ITankHandler<IInfusionHandler> {
        private final ChemicalTankBuilder.BasicInfusionTank infusionTank;
        private final IInfusionHandler infusionTankInsertOnly;
        private final IInfusionHandler infusionTankExtractOnly;
        private long tankCapacity;

        public InfusionTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = (long)tank.getCapacity() * 1000L;
            this.infusionTank = new ChemicalTankBuilder.BasicInfusionTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.infusionTankInsertOnly = new WrapperInfusionHandler((IInfusionHandler)this.infusionTank, true, false);
            this.infusionTankExtractOnly = new WrapperInfusionHandler((IInfusionHandler)this.infusionTank, false, true);
        }

        @Override
        public IInfusionHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.infusionTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.infusionTankExtractOnly;
                default -> this.infusionTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.infusionTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundTag nbt) {
            this.infusionTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundTag save() {
            return !this.infusionTank.isEmpty() ? this.infusionTank.serializeNBT() : null;
        }

        @Override
        public MutableComponent getContentsInfo() {
            InfusionStack stack = (InfusionStack)this.infusionTank.getStack();
            if (!stack.isEmpty()) {
                return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.type.mekanism.infusion")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)stack.getTranslationKey())).m_130946_(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.infusionTank.getCapacity() / 1000L + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, RandomSource random) {
            IInfusionHandler toHandler;
            InfusionStack infusionStack;
            long used;
            IInfusionHandler fromHandler;
            if (this.infusionTank.getStored() < this.infusionTank.getCapacity() && (fromHandler = this.getHandler(world.m_7702_(pullFromPos), facing)) != null && (used = (infusionStack = (InfusionStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((InfusionStack)this.infusionTank.insertChemical((ChemicalStack)infusionStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.infusionTank.insertChemical((ChemicalStack)((InfusionStack)fromHandler.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
            if (!this.infusionTank.isEmpty() && (toHandler = this.getHandler(world.m_7702_(pushToPos), facing.m_122424_())) != null && (used = (infusionStack = (InfusionStack)this.infusionTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((InfusionStack)toHandler.insertChemical((ChemicalStack)infusionStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical((ChemicalStack)((InfusionStack)this.infusionTank.extractChemical(used, Action.EXECUTE)), Action.EXECUTE);
            }
        }

        @Override
        public int getComparatorOutput() {
            long amount = ((InfusionStack)this.infusionTank.getStack()).getAmount();
            float fill = (float)amount / (float)this.infusionTank.getCapacity();
            return Mth.m_14143_((float)(fill * 14.0f)) + (amount > 0L ? 1 : 0);
        }

        @Override
        public Component getDisplayName() {
            return Component.m_237115_((String)"info.endertanks.tank.type.mekanism.infusion");
        }

        public IInfusionHandler getHandler(BlockEntity tile, Direction facing) {
            return tile == null ? null : (IInfusionHandler)tile.getCapability(Capabilities.INFUSION_HANDLER, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IInfusionHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<IInfusionHandler> create(IEnderTankInfo tank) {
                return new InfusionTankHandler(tank);
            }
        }
    }
}

