/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.config.EConfig;

public class WitchWaterBlock
extends LiquidBlock {
    public WitchWaterBlock(Supplier<? extends FlowingFluid> pFluid, BlockBehaviour.Properties pProperties) {
        super(pFluid, pProperties);
    }

    public void m_7892_(BlockState pState, Level level, BlockPos pPos, Entity entity) {
        if (!level.f_46443_) {
            WitchWaterBlock.witchWaterEntityEffects(level, entity);
        }
    }

    public static void witchWaterEntityEffects(Level level, Entity entity) {
        if (entity.m_6084_()) {
            EntityType entityType = entity.m_6095_();
            if (((Boolean)EConfig.SERVER.allowWitchWaterEntityConversion.get()).booleanValue()) {
                if (entityType == EntityType.f_20492_) {
                    Villager villager = (Villager)entity;
                    if (level.m_46791_() != Difficulty.PEACEFUL) {
                        if (!villager.m_6162_() && villager.m_7141_().m_35571_() == VillagerProfession.f_35589_) {
                            if (WitchWaterBlock.attemptToConvertEntity(level, (Entity)villager, EntityType.f_20495_) != null) {
                                villager.m_35524_();
                            }
                        } else {
                            ZombieVillager zombieVillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
                            if (zombieVillager != null) {
                                zombieVillager.m_6518_((ServerLevelAccessor)level, level.m_6436_(zombieVillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), null);
                                zombieVillager.m_34375_(villager.m_7141_());
                                zombieVillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                                zombieVillager.m_34411_(villager.m_6616_().m_45388_());
                                zombieVillager.m_34373_(villager.m_7809_());
                                ForgeEventFactory.onLivingConvert((LivingEntity)villager, (LivingEntity)zombieVillager);
                                villager.m_146870_();
                            }
                        }
                    }
                } else if (entityType == EntityType.f_20524_) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20497_);
                } else if (entityType == EntityType.f_20558_) {
                    entity.m_20088_().m_135381_(Creeper.f_32274_, (Object)true);
                } else if (entityType == EntityType.f_20479_) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20554_);
                } else if (entityType == EntityType.f_20480_) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20453_);
                } else if (entityType == EntityType.f_20510_ || entityType == EntityType.f_20511_) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20531_);
                } else if (entityType == EntityType.f_20456_) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20500_);
                } else if (entityType == EntityType.f_20504_) {
                    ((MushroomCow)entity).m_28464_(MushroomCow.MushroomType.BROWN);
                } else if (entityType == EntityType.f_147039_) {
                    ((Axolotl)entity).m_28464_(Axolotl.Variant.BLUE);
                } else if (entityType == EntityType.f_20517_) {
                    ((Rabbit)entity).m_28464_(Rabbit.Variant.EVIL);
                } else if (entityType == EntityType.f_20516_) {
                    WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20455_);
                } else if (entityType == EntityType.f_20457_) {
                    if (level.f_46441_.m_188499_()) {
                        WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20502_);
                    } else {
                        WitchWaterBlock.attemptToConvertEntity(level, entity, EntityType.f_20525_);
                    }
                }
            }
            if (entityType == EntityType.f_20532_) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 210));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 210, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 210));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 210));
            }
        }
    }

    @Nullable
    private static <T extends Mob> T attemptToConvertEntity(Level level, Entity entity, EntityType<T> newType) {
        if (level.m_46791_() != Difficulty.PEACEFUL && entity instanceof LivingEntity) {
            Mob newEntity = (Mob)newType.m_20615_(level);
            if (newEntity != null) {
                ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                newEntity.m_20359_(entity);
                ForgeEventFactory.onFinalizeSpawn((Mob)newEntity, (ServerLevelAccessor)serverLevel, (DifficultyInstance)level.m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.CONVERSION, null, null);
                newEntity.m_21557_(newEntity.m_21525_());
                if (entity.m_8077_()) {
                    newEntity.m_6593_(entity.m_7770_());
                    newEntity.m_20340_(entity.m_20151_());
                }
                newEntity.m_21530_();
                ForgeEventFactory.onLivingConvert((LivingEntity)((LivingEntity)entity), (LivingEntity)newEntity);
                serverLevel.m_47205_((Entity)newEntity);
                entity.m_146870_();
            }
            return (T)newEntity;
        }
        return null;
    }
}

