/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.blockentity.ETankBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.FluidHelper;
import thedarkcolour.exdeorum.client.CompostColors;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.material.BarrelMaterial;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.barrel.BarrelCompostRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.FluidTransformationRecipe;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.ESounds;

public class BarrelBlockEntity
extends ETankBlockEntity {
    private static final int MOSS_SPREAD_RANGE = 2;
    private static final int MAX_CAPACITY = 1000;
    private final ItemHandler item = new ItemHandler();
    private final FluidHandler tank = new FluidHandler();
    public float progress;
    public short compost;
    public short r;
    public short g;
    public short b;
    private boolean isBeingFilledByPlayer;
    public final boolean transparent;
    @Nullable
    public FluidTransformationRecipe currentTransformRecipe = null;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.item);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.tank);

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.BARREL.get(), pos, state);
        this.transparent = BarrelMaterial.TRANSPARENT_BARRELS.contains(state.m_60734_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
        this.itemHandler.invalidate();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("item", (Tag)this.item.serializeNBT());
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128376_("compost", this.compost);
        nbt.m_128350_("progress", this.progress);
        nbt.m_128376_("r", this.r);
        nbt.m_128376_("g", this.g);
        nbt.m_128376_("b", this.b);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.item.deserializeNBT(nbt.m_128469_("item"));
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.compost = nbt.m_128448_("compost");
        this.progress = nbt.m_128457_("progress");
        this.r = nbt.m_128448_("r");
        this.g = nbt.m_128448_("g");
        this.b = nbt.m_128448_("b");
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.item.getStackInSlot(0));
        buffer.writeFluidStack(this.tank.getFluid());
        buffer.writeShort((int)this.compost);
        buffer.writeFloat(this.progress);
        buffer.writeShort((int)this.r);
        buffer.writeShort((int)this.g);
        buffer.writeShort((int)this.b);
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        this.item.setStackInSlot(0, buffer.m_130267_());
        this.tank.setFluid(buffer.readFluidStack());
        this.compost = buffer.readShort();
        this.progress = buffer.readFloat();
        this.r = buffer.readShort();
        this.g = buffer.readShort();
        this.b = buffer.readShort();
    }

    public boolean isBrewing() {
        return this.tank.getFluidAmount() == 1000 && this.progress != 0.0f && !this.isBurning();
    }

    public boolean isBurning() {
        return this.m_58900_().m_278200_() && BarrelBlockEntity.isHotFluid(this.tank.getFluid().getFluid().getFluidType()) && this.progress != 0.0f;
    }

    public boolean isComposting() {
        return this.compost == 1000;
    }

    public boolean hasNoSolids() {
        return this.compost <= 0 && this.item.getStackInSlot(0).m_41619_();
    }

    public boolean hasFullWater() {
        return this.tank.getFluidAmount() == 1000 && this.tank.getFluid().getFluid().m_205067_(FluidTags.f_13131_);
    }

    public static boolean isHotFluid(FluidType fluidType) {
        return fluidType.getTemperature() > 575;
    }

    private void spawnParticlesIfBurning() {
        if (this.isBurning()) {
            BlockPos pos = this.m_58899_();
            int burnTicks = (int)(this.progress * 300.0f);
            if (burnTicks % 30 == 0) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            } else if (burnTicks % 5 == 0) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public ItemStack getItem() {
        return this.item.getStackInSlot(0);
    }

    private void setItem(ItemStack item) {
        this.item.setStackInSlot(0, item);
    }

    @Override
    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (!this.getItem().m_41619_()) {
            return this.giveResultItem(level);
        }
        if (this.hasNoSolids()) {
            Optional itemFluidCapOptional;
            boolean wasBurning = this.isBurning();
            this.isBeingFilledByPlayer = true;
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
                this.isBeingFilledByPlayer = false;
                this.tryInWorldFluidMixing();
                this.markUpdated();
                if (wasBurning && !BarrelBlockEntity.isHotFluid(this.tank.getFluid().getFluid().getFluidType())) {
                    this.progress = 0.0f;
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            this.isBeingFilledByPlayer = false;
            ItemStack playerItem = player.m_21120_(hand);
            if (((Boolean)EConfig.SERVER.allowWaterBottleTransfer.get()).booleanValue()) {
                FluidStack fluid = new FluidStack((Fluid)Fluids.f_76193_, 250);
                if (playerItem.m_41720_() == Items.f_42589_ && PotionUtils.m_43579_((ItemStack)playerItem) == Potions.f_43599_) {
                    if (this.tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        if (!player.m_150110_().f_35937_) {
                            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
                        }
                        this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        this.markUpdated();
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                } else if (playerItem.m_41720_() == Items.f_42590_ && this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                    BarrelBlockEntity.extractWaterBottle((IFluidHandler)this.tank, level, player, playerItem, fluid);
                    this.markUpdated();
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
            if ((itemFluidCapOptional = playerItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve()).isPresent()) {
                IFluidHandlerItem itemFluidCap = (IFluidHandlerItem)itemFluidCapOptional.get();
                FluidStack itemFluid = itemFluidCap.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                BarrelFluidMixingRecipe recipe = RecipeUtil.getFluidMixingRecipe(this.tank.getFluid(), itemFluid.getFluid());
                if (recipe != null && this.tank.getFluidAmount() >= recipe.baseFluidAmount && itemFluid.getAmount() == 1000) {
                    if (!level.f_46443_) {
                        this.tank.drain(recipe.baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack result = new ItemStack((ItemLike)recipe.result);
                        result.m_41751_(recipe.getResultNbt());
                        this.setItem(result);
                        if (recipe.consumesAdditive) {
                            itemFluidCap.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            player.m_21008_(hand, itemFluidCap.getContainer());
                        }
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        ItemStack playerItem = player.m_21120_(hand);
        if (!level.f_46443_) {
            ItemStack handItem = this.item.insertItem(0, player.m_150110_().f_35937_ ? playerItem.m_41777_() : playerItem, false);
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, handItem);
                this.giveResultItem(level);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected static void extractWaterBottle(IFluidHandler tank, Level level, Player player, ItemStack playerItem, FluidStack fluid) {
        ItemStack bottle;
        if (!player.m_150110_().f_35937_) {
            playerItem.m_41774_(1);
        }
        if (!player.m_36356_(bottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_))) {
            player.m_36176_(bottle, false);
        }
        tank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11769_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private InteractionResult giveResultItem(Level level) {
        if (!level.f_46443_) {
            BarrelBlockEntity.popOutItem(level, this.f_58858_, this.item.extract(false));
            this.setItem(ItemStack.f_41583_);
            this.markUpdated();
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static void popOutItem(Level level, BlockPos pos, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_()) {
            RandomSource rand = level.f_46441_;
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, stack);
            itemEntity.m_20334_(rand.m_188583_() * 0.05, 0.2, rand.m_188583_() * 0.05);
            level.m_7967_((Entity)itemEntity);
        }
    }

    private boolean tryCrafting(ItemStack input, boolean simulate) {
        boolean crafted = false;
        if (!this.tank.isEmpty()) {
            crafted = this.tryMixing(input, simulate);
        } else if (!this.isComposting()) {
            crafted = this.tryComposting(input, simulate);
        }
        if (crafted) {
            if (!simulate) {
                this.markUpdated();
            }
            return true;
        }
        return false;
    }

    private boolean tryMixing(ItemStack playerItem, boolean simulate) {
        if (this.isBurning()) {
            return false;
        }
        BarrelMixingRecipe recipe = RecipeUtil.getBarrelMixingRecipe(this.f_58857_.m_7465_(), playerItem, this.tank.getFluid());
        if (recipe != null) {
            if (!simulate) {
                this.tank.drain(recipe.fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                ItemStack result = new ItemStack((ItemLike)recipe.result);
                result.m_41751_(recipe.getResultNbt());
                this.setItem(result);
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ESounds.BARREL_MIXING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private boolean tryComposting(ItemStack stack, boolean simulate) {
        if (simulate) {
            return RecipeUtil.isCompostable(stack);
        }
        BarrelCompostRecipe recipe = RecipeUtil.getBarrelCompostRecipe(stack);
        if (recipe != null) {
            this.addCompost(stack, recipe.getVolume());
            return true;
        }
        return false;
    }

    private void addCompost(ItemStack playerItem, int volume) {
        short oldCompost = this.compost;
        this.compost = (short)Math.min(1000, this.compost + volume);
        if (this.compost != 0) {
            if (!CompostColors.isLoaded()) {
                CompostColors.loadColors();
            }
            float weightNew = (float)(this.compost - oldCompost) / (float)this.compost;
            float weightOld = 1.0f - weightNew;
            Vector3i color = (Vector3i)CompostColors.COLORS.getOrDefault((Object)playerItem.m_41720_(), (Object)CompostColors.DEFAULT_COLOR);
            this.r = (short)(weightNew * (float)color.x + weightOld * (float)this.r);
            this.g = (short)(weightNew * (float)color.y + weightOld * (float)this.g);
            this.b = (short)(weightNew * (float)color.z + weightOld * (float)this.b);
        }
        this.f_58857_.m_247517_(null, this.f_58858_, (SoundEvent)ESounds.BARREL_ADD_COMPOST.get(), SoundSource.BLOCKS);
    }

    public void tryInWorldFluidMixing() {
        BlockPos abovePos;
        BlockState aboveBlockState;
        FluidState aboveFluidState;
        Fluid aboveFluid;
        if (!this.f_58857_.f_46443_ && !this.tank.isEmpty() && this.item.getStackInSlot(0).m_41619_() && (aboveFluid = (aboveFluidState = (aboveBlockState = this.f_58857_.m_8055_(abovePos = this.f_58858_.m_7494_())).m_60819_()).m_76152_()) != Fluids.f_76191_) {
            Fluid fluid;
            FluidStack fluidStack = this.tank.getFluid();
            if (aboveFluid instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)aboveFluid;
                fluid = flowing.m_5613_();
            } else {
                fluid = aboveFluid;
            }
            BarrelFluidMixingRecipe recipe = RecipeUtil.getFluidMixingRecipe(fluidStack, fluid);
            if (recipe != null) {
                if (!recipe.consumesAdditive) {
                    this.tank.drain(recipe.baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                    this.setItem(new ItemStack((ItemLike)recipe.result));
                } else {
                    BucketPickup pickup;
                    Block block = aboveBlockState.m_60734_();
                    if (block instanceof BucketPickup && !(pickup = (BucketPickup)block).m_142598_((LevelAccessor)this.f_58857_, abovePos, aboveBlockState).m_41619_()) {
                        this.tank.drain(recipe.baseFluidAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.setItem(new ItemStack((ItemLike)recipe.result));
                    }
                }
            }
        }
    }

    public void updateFluidTransform() {
        if (!this.f_58857_.f_46443_) {
            if (this.tank.getFluidAmount() != 1000) {
                this.currentTransformRecipe = null;
            } else {
                BlockState belowState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
                this.currentTransformRecipe = RecipeUtil.getFluidTransformationRecipe(this.tank.getFluid().getFluid(), belowState);
                if (this.currentTransformRecipe != null) {
                    int color = this.currentTransformRecipe.resultColor;
                    this.r = (short)(color >> 16 & 0xFF);
                    this.g = (short)(color >> 8 & 0xFF);
                    this.b = (short)(color & 0xFF);
                    this.markUpdated();
                }
            }
            this.progress = 0.0f;
        }
    }

    public static void fillRainWater(EBlockEntity block, FluidHelper tank) {
        if (tank.isEmpty()) {
            tank.setFluid(new FluidStack((Fluid)Fluids.f_76193_, 1));
            block.markUpdated();
        } else if (tank.getFluid().getFluid() == Fluids.f_76193_) {
            tank.getFluid().grow(1);
            block.markUpdated();
        }
    }

    private static float getProgressStep() {
        return ((Double)EConfig.SERVER.barrelProgressStep.get()).floatValue();
    }

    private void doCompost() {
        this.progress += BarrelBlockEntity.getProgressStep();
        this.markUpdated();
        if (this.progress >= 1.0f) {
            this.progress = 0.0f;
            this.compost = 0;
            this.setItem(new ItemStack((ItemLike)Items.f_42329_));
            this.f_58857_.m_247517_(null, this.f_58858_, (SoundEvent)ESounds.BARREL_COMPOST.get(), SoundSource.BLOCKS);
        }
    }

    private static ItemStack getRemainderItem(ItemStack stack) {
        return stack.m_41720_() instanceof BowlFoodItem || stack.m_41720_() == Items.f_42718_ ? new ItemStack((ItemLike)Items.f_42399_) : stack.getCraftingRemainingItem();
    }

    public void onLoad() {
        this.tryInWorldFluidMixing();
        this.updateFluidTransform();
    }

    private class ItemHandler
    extends ItemStackHandler {
        private ItemHandler() {
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return BarrelBlockEntity.this.tryCrafting(stack, true);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            if (!((ItemStack)this.stacks.get(slot)).m_41619_()) {
                return stack;
            }
            if (BarrelBlockEntity.this.tryCrafting(stack, simulate)) {
                if (stack.m_41613_() == 1) {
                    return BarrelBlockEntity.getRemainderItem(stack);
                }
                BarrelBlockEntity.popOutItem(BarrelBlockEntity.this.f_58857_, BarrelBlockEntity.this.f_58858_, BarrelBlockEntity.getRemainderItem(stack));
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
            }
            return stack;
        }

        public ItemStack extract(boolean simulate) {
            return this.extractItem(0, 1, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            if (!((BarrelBlockEntity)BarrelBlockEntity.this).f_58857_.f_46443_) {
                BarrelBlockEntity.this.markUpdated();
            }
        }
    }

    private class FluidHandler
    extends FluidHelper {
        public FluidHandler() {
            super(1000);
        }

        public boolean isFluidValid(FluidStack stack) {
            return !BarrelBlockEntity.this.isBrewing() && BarrelBlockEntity.this.hasNoSolids();
        }

        protected void onContentsChanged() {
            if (!BarrelBlockEntity.this.isBeingFilledByPlayer) {
                BarrelBlockEntity.this.tryInWorldFluidMixing();
                BarrelBlockEntity.this.markUpdated();
            }
            BarrelBlockEntity.this.updateFluidTransform();
        }
    }

    public static class Ticker
    implements BlockEntityTicker<BarrelBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, BarrelBlockEntity barrel) {
            if (!level.f_46443_) {
                FluidHandler tank = barrel.tank;
                if (barrel.isComposting()) {
                    barrel.doCompost();
                } else if (BarrelBlockEntity.isHotFluid(tank.getFluid().getFluid().getFluidType()) && state.m_278200_()) {
                    float f;
                    barrel.progress += BarrelBlockEntity.getProgressStep();
                    if (f >= 1.0f) {
                        if (tank.getFluidAmount() == 1000) {
                            Fluid fluid = tank.getFluid().getFluid();
                            level.m_46597_(pos, fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)level, pos, fluid.m_76145_()));
                        } else {
                            level.m_46597_(pos, Blocks.f_50083_.m_49966_());
                        }
                    }
                    barrel.markUpdated();
                } else if (barrel.currentTransformRecipe != null) {
                    FluidTransformationRecipe recipe = barrel.currentTransformRecipe;
                    int catalysts = 0;
                    for (BlockPos cursor : BlockPos.m_121976_((int)(pos.m_123341_() - 1), (int)(pos.m_123342_() - 1), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() - 1), (int)(pos.m_123343_() + 1))) {
                        BlockState byproduct;
                        BlockPos above;
                        RandomSource rand;
                        if (!recipe.catalyst.test(level.m_8055_(cursor))) continue;
                        ++catalysts;
                        if (recipe.byproducts.isEmpty() || (rand = level.f_46441_).m_188503_(1500) != 0 || !level.m_8055_(above = cursor.m_7494_()).m_60795_() || !(byproduct = recipe.byproducts.getRandom(rand)).m_60710_((LevelReader)level, above)) continue;
                        level.m_46597_(above, byproduct);
                    }
                    if (catalysts == 0) {
                        barrel.currentTransformRecipe = null;
                    } else {
                        barrel.progress += (float)catalysts * (1.0f / (float)barrel.currentTransformRecipe.duration);
                        if (barrel.progress >= 0.99999f) {
                            barrel.progress = 0.0f;
                            level.m_5594_(null, pos, (SoundEvent)ESounds.BARREL_FLUID_TRANSFORM.get(), SoundSource.BLOCKS, 1.0f, 0.6f);
                            tank.setFluid(FluidStack.EMPTY);
                            tank.fill(new FluidStack(recipe.resultFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                        }
                        barrel.markUpdated();
                    }
                } else if (((Boolean)EConfig.SERVER.barrelsCollectRainWater.get()).booleanValue() && tank.getFluidAmount() < 1000 && level.m_46758_(pos.m_7494_()) && barrel.item.getStackInSlot(0).m_41619_() && barrel.compost == 0) {
                    BarrelBlockEntity.fillRainWater(barrel, tank);
                    if (tank.getFluidAmount() == 1000) {
                        barrel.updateFluidTransform();
                    }
                } else if (barrel.hasFullWater() && tank.getFluid().getFluid().getFluidType() == ForgeMod.WATER_TYPE.get()) {
                    RandomSource rand = level.f_46441_;
                    if (state.m_278200_() && rand.m_188503_(500) == 0) {
                        BlockPos randomPos = pos.m_7918_(rand.m_216332_(-2, 2), -1, rand.m_216332_(-2, 2));
                        Block randomBlock = level.m_8055_(randomPos).m_60734_();
                        if (randomBlock == Blocks.f_50652_) {
                            level.m_7731_(randomPos, Blocks.f_50079_.m_49966_(), 3);
                        } else if (randomBlock == Blocks.f_50222_) {
                            level.m_7731_(randomPos, Blocks.f_50223_.m_49966_(), 3);
                        }
                    }
                }
            } else {
                barrel.spawnParticlesIfBurning();
            }
        }
    }
}

