/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import thedarkcolour.exdeorum.block.InfestedLeavesBlock;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EBlocks;

public class InfestedLeavesBlockEntity
extends EBlockEntity {
    public static final float PROGRESS_INTERVAL = 0.005f;
    public static final int SPREAD_INTERVAL = 40;
    private float progress;
    private int spreadTimer;
    private BlockState mimic = Blocks.f_50050_.m_49966_();

    public InfestedLeavesBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.INFESTED_LEAVES.get(), pos, state);
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.progress);
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        buffer.readFloat();
    }

    private void trySpread(Level level) {
        int x = level.f_46441_.m_188503_(3) - 1;
        int y = level.f_46441_.m_188503_(3) - 1;
        int z = level.f_46441_.m_188503_(3) - 1;
        BlockPos targetPos = this.m_58899_().m_7918_(x, y, z);
        BlockState state = level.m_8055_(targetPos);
        if (state.m_204336_(BlockTags.f_13035_) && state.m_60734_() != EBlocks.INFESTED_LEAVES.get()) {
            InfestedLeavesBlock.setBlock(level, targetPos, state);
            BlockEntity te = level.m_7702_(targetPos);
            if (te instanceof InfestedLeavesBlockEntity) {
                InfestedLeavesBlockEntity leaves = (InfestedLeavesBlockEntity)te;
                leaves.setMimic(state);
                leaves.m_6596_();
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        HolderLookup.RegistryLookup holderLookup = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        this.mimic = NbtUtils.m_247651_((HolderGetter)holderLookup, (CompoundTag)nbt.m_128469_("mimic"));
        this.progress = nbt.m_128457_("progress");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.mimic == null || this.mimic.m_60734_() == EBlocks.INFESTED_LEAVES.get()) {
            this.mimic = Blocks.f_50050_.m_49966_();
        }
        nbt.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        nbt.m_128350_("progress", this.progress);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
    }

    public static class Ticker
    implements BlockEntityTicker<InfestedLeavesBlockEntity> {
        public void tick(Level level, BlockPos pos, BlockState state, InfestedLeavesBlockEntity leaves) {
            if (leaves.progress < 1.0f) {
                leaves.progress = Math.min(1.0f, leaves.progress + 0.005f);
                if (leaves.progress == 1.0f) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)InfestedLeavesBlock.FULLY_INFESTED, (Comparable)Boolean.valueOf(true)), 1);
                }
            }
            if (!level.f_46443_ && leaves.progress > 0.6f) {
                ++leaves.spreadTimer;
                if (leaves.spreadTimer >= 40) {
                    leaves.trySpread(level);
                    leaves.spreadTimer = level.f_46441_.m_188503_(10);
                }
            }
        }
    }
}

