/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import thedarkcolour.exdeorum.client.ClientHandler;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.registry.EBlocks;

public class ClientXeiUtil {
    private static final ItemStack OAK_BARREL = new ItemStack((ItemLike)DefaultMaterials.OAK_BARREL.getItem());
    private static final FluidState EMPTY = Fluids.f_76191_.m_76145_();
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final Vector3f L1 = new Vector3f(0.4f, 0.0f, 1.0f).normalize();
    private static final Vector3f L2 = new Vector3f(-0.4f, 1.0f, -0.2f).normalize();

    public static void renderItemAlternativeModel(GuiGraphics graphics, BakedModel model, ItemStack stack, int xOffset, int yOffset) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)(8 + xOffset), (float)(8 + yOffset), 150.0f);
        try {
            boolean flag;
            pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.m_85841_(16.0f, 16.0f, 16.0f);
            boolean bl = flag = !model.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            mc.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
            graphics.m_280262_();
            if (flag) {
                Lighting.m_84931_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
            crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashreportcategory.m_128165_("Registry Name", () -> BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
            throw new ReportedException(crashreport);
        }
        pose.m_85849_();
        RenderSystem.disableBlend();
    }

    public static void renderFilledCompostBarrel(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        RenderSystem.enableDepthTest();
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91304_().getModel(ClientHandler.OAK_BARREL_COMPOSTING);
        ClientXeiUtil.renderItemAlternativeModel(guiGraphics, model, OAK_BARREL, xOffset, yOffset);
        RenderSystem.disableDepthTest();
    }

    public static void renderBlock(GuiGraphics guiGraphics, BlockState state, float x, float y, float z, float scale) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(-scale, -scale, -scale);
        poseStack.m_252880_(-0.5f, -0.5f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        poseStack.m_252880_(0.5f, 0.0f, -0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        poseStack.m_252880_(-0.5f, 0.0f, 0.5f);
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_252880_(0.0f, 0.0f, -1.0f);
        FluidState fluidState = state.m_60819_();
        if (fluidState.m_76178_()) {
            MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderSystem.setupGui3DDiffuseLighting((Vector3f)L1, (Vector3f)L2);
            if (state.m_60713_((Block)EBlocks.INFESTED_LEAVES.get())) {
                BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
                BakedModel bakedmodel = blockRenderer.m_110910_(state);
                for (RenderType renderType : bakedmodel.getRenderTypes(state, RandomSource.m_216335_((long)42L), ModelData.EMPTY)) {
                    blockRenderer.m_110937_().renderModel(poseStack.m_85850_(), buffers.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, bakedmodel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
                }
            } else {
                Minecraft.m_91087_().m_91289_().m_110912_(state, poseStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
            }
            buffers.m_109911_();
        } else {
            RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
            PoseStack modelView = RenderSystem.getModelViewStack();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder builder = tesselator.m_85915_();
            renderType.m_110185_();
            modelView.m_85836_();
            modelView.m_252931_(poseStack.m_85850_().m_252922_());
            RenderSystem.applyModelViewMatrix();
            builder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
            Dummy.tempState = state;
            Dummy.tempFluid = fluidState;
            Minecraft.m_91087_().m_91289_().m_234363_(BlockPos.f_121853_, (BlockAndTintGetter)Dummy.INSTANCE, (VertexConsumer)builder, state, state.m_60819_());
            Dummy.tempFluid = EMPTY;
            Dummy.tempState = AIR;
            if (builder.m_85732_()) {
                tesselator.m_85914_();
            }
            renderType.m_110188_();
            modelView.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
        poseStack.m_85849_();
    }

    public static void renderItemWithAsterisk(GuiGraphics graphics, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91291_().m_174264_(stack, (Level)mc.f_91073_, null, 0);
        ClientXeiUtil.renderItemAlternativeModel(graphics, model, stack, 0, 0);
        ClientXeiUtil.renderAsterisk(graphics, 0, 0);
    }

    public static void renderAsterisk(GuiGraphics graphics, int xOffset, int yOffset) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280056_(font, "*", xOffset + 19 - 2 - font.m_92895_("*"), yOffset + 12, 0xFF5555, true);
        graphics.m_280168_().m_85849_();
    }

    private static enum Dummy implements BlockAndTintGetter
    {
        INSTANCE;

        private static BlockState tempState;
        private static FluidState tempFluid;

        public float m_7717_(Direction pDirection, boolean pShade) {
            return 1.0f;
        }

        public LevelLightEngine m_5518_() {
            return Minecraft.m_91087_().f_91073_.m_5518_();
        }

        public int m_6171_(BlockPos pBlockPos, ColorResolver pColorResolver) {
            return 0;
        }

        public int m_45517_(LightLayer pLightType, BlockPos pBlockPos) {
            return 15;
        }

        public int m_45524_(BlockPos pBlockPos, int pAmount) {
            return 15;
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pPos) {
            return null;
        }

        public BlockState m_8055_(BlockPos pos) {
            return pos.equals((Object)BlockPos.f_121853_) ? tempState : AIR;
        }

        public FluidState m_6425_(BlockPos pos) {
            return pos.equals((Object)BlockPos.f_121853_) ? tempFluid : EMPTY;
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }

        static {
            tempState = AIR;
            tempFluid = EMPTY;
        }
    }

    @FunctionalInterface
    public static interface RenderBlockFn {
        public void renderBlock(BlockState var1, PoseStack var2, MultiBufferSource.BufferSource var3);
    }
}

