/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.emi;

import com.google.common.collect.ImmutableList;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.compat.emi.BlockEmiWidget;
import thedarkcolour.exdeorum.compat.emi.EEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.EmiUtil;
import thedarkcolour.exdeorum.compat.emi.ExDeorumEmiPlugin;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;

class CrookEmiRecipe
extends EEmiRecipe {
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final List<BlockState> states;
    private final BlockPredicate predicate;

    public CrookEmiRecipe(CrookRecipe recipe) {
        super(recipe);
        this.inputs = EmiUtil.inputs(recipe.blockPredicate());
        ItemStack result = new ItemStack((ItemLike)recipe.result(), 1);
        result.m_41751_(recipe.getResultNbt());
        this.outputs = ImmutableList.of((Object)EmiStack.of((ItemStack)result));
        this.states = XeiUtil.getStates(recipe.blockPredicate());
        this.predicate = recipe.blockPredicate();
    }

    public EmiRecipeCategory getCategory() {
        return ExDeorumEmiPlugin.CROOK;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 48;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 50, 18);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 79, 17).recipeContext((EmiRecipe)this);
        widgets.add((Widget)new BlockEmiWidget(this.states, XeiUtil.getExtraDetails(this.predicate), 28, 18, 20.0f));
    }
}

