/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.compat.jade.ExDeorumJadePlugin;

enum BarrelComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            short volume = barrel.compost;
            if (volume == 1000 || barrel.isBrewing()) {
                progress = (int)(barrel.progress * 100.0f);
                tooltip.add((Component)Component.m_237113_((String)"Progress: ").m_130946_(progress + "%"));
            } else if (volume > 0) {
                int volumePercent = (int)((float)volume / 10.0f);
                tooltip.add((Component)Component.m_237113_((String)"Volume: ").m_130946_(volumePercent + "%"));
            } else if (barrel.isBurning()) {
                progress = 300 - (int)(barrel.progress * 300.0f);
                tooltip.add((Component)Component.m_237113_((String)"Burning! ").m_130946_(progress / 20 + "s"));
            }
            if (accessor.getPlayer().m_6144_()) {
                FluidStack fluid = barrel.getTank().getFluid();
                tooltip.add(IElementHelper.get().fluid(JadeFluidObject.of((Fluid)fluid.getFluid(), (long)fluid.getAmount())));
            }
        }
    }

    public ResourceLocation getUid() {
        return ExDeorumJadePlugin.BARREL;
    }
}

