/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.compat.PreferredOres;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;

public class TagResultRecipe {

    public static class Finished
    implements FinishedRecipe {
        private final TagKey<Item> resultTag;
        private final FinishedRecipe recipe;

        public Finished(TagKey<Item> resultTag, FinishedRecipe recipe) {
            this.resultTag = resultTag;
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            JsonObject recipeJson = new JsonObject();
            this.recipe.m_7917_(recipeJson);
            recipeJson.addProperty("type", BuiltInRegistries.f_256769_.m_7981_((Object)this.recipe.m_6637_()).toString());
            json.addProperty("result_tag", this.resultTag.f_203868_().toString());
            json.add("recipe", (JsonElement)recipeJson);
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ERecipeSerializers.TAG_RESULT.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.recipe.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.recipe.m_6448_();
        }
    }

    public static class Serializer<T extends Recipe<?>>
    implements RecipeSerializer<T> {
        public T m_6729_(ResourceLocation id, JsonObject json) {
            String resultTag = GsonHelper.m_13906_((JsonObject)json, (String)"result_tag");
            if (ResourceLocation.m_135830_((String)resultTag)) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(resultTag));
                Item preferredItem = PreferredOres.getPreferredOre((TagKey<Item>)tag);
                if (preferredItem != Items.f_41852_) {
                    JsonObject recipeJson = GsonHelper.m_13930_((JsonObject)json, (String)"recipe");
                    if (recipeJson.has("result")) {
                        JsonObject resultJson = GsonHelper.m_13930_((JsonObject)recipeJson, (String)"result");
                        String itemId = preferredItem.m_204114_().m_205785_().m_135782_().toString();
                        resultJson.addProperty("item", itemId);
                        return (T)RecipeManager.m_44045_((ResourceLocation)id, (JsonObject)recipeJson);
                    }
                    ExDeorum.LOGGER.error("Skipping recipe {} with unhandled recipe type, \"{}\". Please report to Ex Deorum GitHub.", (Object)id, (Object)recipeJson.get("type").getAsString());
                } else {
                    ExDeorum.LOGGER.info("Skipping recipe {} as ExDeorum could not determine substitute for tag {}", (Object)id, (Object)tag.f_203868_());
                }
            } else {
                ExDeorum.LOGGER.error("Invalid resource location for \"result_tag\" in recipe {}", (Object)id);
            }
            return null;
        }

        @Nullable
        public T m_8005_(ResourceLocation id, FriendlyByteBuf buffer) {
            return null;
        }

        public void m_6178_(FriendlyByteBuf buffer, T recipe) {
        }
    }
}

