/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.cache;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleHeatRecipe;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class CrucibleHeatRecipeCache {
    private RecipeManager recipeManager;
    @Nullable
    private Object2IntMap<BlockState> recipes;

    public CrucibleHeatRecipeCache(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public int getValue(BlockState state) {
        if (this.recipes == null) {
            this.buildRecipes();
        }
        return this.recipes.getInt((Object)state);
    }

    private void buildRecipes() {
        this.recipes = new Object2IntOpenHashMap();
        for (CrucibleHeatRecipe recipe : this.recipeManager.m_44054_((RecipeType)ERecipeTypes.CRUCIBLE_HEAT_SOURCE.get()).values()) {
            recipe.blockPredicate().possibleStates().forEach(state -> this.recipes.put(state, recipe.heatValue()));
        }
        this.recipeManager = null;
    }

    public ObjectSet<Object2IntMap.Entry<BlockState>> getEntries() {
        if (this.recipes == null) {
            this.buildRecipes();
        }
        return this.recipes.object2IntEntrySet();
    }
}

