/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.compat.jei;

import java.lang.reflect.Field;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.jei.category.CompactingCategory;
import net.permutated.exmachinis.util.ResourceUtil;
import net.permutated.exmachinis.util.TranslationKey;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceUtil.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompactingCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_COMPACTOR_BLOCK.get()), new RecipeType[]{CompactingCategory.RECIPE_TYPE});
        try {
            Field hammer = ExDeorumJeiPlugin.class.getDeclaredField("HAMMER");
            hammer.setAccessible(true);
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_HAMMER_BLOCK.get()), new RecipeType[]{(RecipeType)hammer.get(null)});
            Field sieve = ExDeorumJeiPlugin.class.getDeclaredField("SIEVE");
            sieve.setAccessible(true);
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModRegistry.FLUX_SIEVE_BLOCK.get()), new RecipeType[]{(RecipeType)sieve.get(null)});
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CompactingCategory.RECIPE_TYPE, ModRegistry.COMPACTING_REGISTRY.getRecipeList());
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.FLUX_COMPACTOR_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("flux_compactor")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.FLUX_HAMMER_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("flux_hammer")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.FLUX_SIEVE_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("flux_sieve")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegistry.ITEM_BUFFER_BLOCK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TranslationKey.translateJei("item_buffer")});
    }
}

