/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.compactor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.util.ItemStackUtil;
import net.permutated.exmachinis.util.WorkStatus;

public class FluxCompactorTile
extends AbstractMachineTile {
    public FluxCompactorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUX_COMPACTOR_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    @Override
    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getUpgradeTickDelay())) {
                int quotient;
                Boolean enabled = (Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.ENABLED);
                if (Boolean.FALSE.equals(enabled)) {
                    this.workStatus = WorkStatus.REDSTONE_DISABLED;
                    return;
                }
                Direction output = (Direction)this.m_58900_().m_61143_((Property)AbstractMachineBlock.OUTPUT);
                BlockPos outPos = this.m_58899_().m_121945_(output);
                BlockEntity target = this.f_58857_.m_7702_(outPos);
                if (target == null) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                IItemHandler itemHandler = target.getCapability(ForgeCapabilities.ITEM_HANDLER, output.m_122424_()).resolve().orElse(null);
                if (itemHandler == null || itemHandler.getSlots() == 0) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                this.workStatus = WorkStatus.WORKING;
                int cost = this.getUpgradeEnergyCost();
                int stored = this.energyStorage.getEnergyStored();
                int maxProcessed = this.getUpgradeItemsProcessed();
                if (stored < cost) {
                    this.workStatus = WorkStatus.OUT_OF_ENERGY;
                    return;
                }
                if (cost > 0 && (quotient = stored / cost) < maxProcessed) {
                    maxProcessed = quotient;
                }
                for (int i = 0; i < this.itemStackHandler.getSlots() && maxProcessed != 0; ++i) {
                    int multiplier;
                    int maxInputs;
                    CompactingRecipe recipe;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || (recipe = ModRegistry.COMPACTING_REGISTRY.findRecipe(stack.m_41720_())) == CompactingRecipe.EMPTY || !recipe.getIngredient().test(stack)) continue;
                    int recipeInput = recipe.getIngredient().count();
                    ItemStack copy = stack.m_41777_();
                    int count = stack.m_41613_();
                    if (count >= (maxInputs = maxProcessed * recipeInput)) {
                        multiplier = maxProcessed;
                        copy.m_41774_(maxInputs);
                        maxProcessed = 0;
                    } else {
                        multiplier = count / recipeInput;
                        int inputUsed = multiplier * recipeInput;
                        copy.m_41774_(inputUsed);
                        maxProcessed -= multiplier;
                    }
                    if (!this.processResults(itemHandler, recipe, multiplier, true)) {
                        return;
                    }
                    int totalCost = cost * multiplier;
                    boolean result = this.energyStorage.consumeEnergy(totalCost, true);
                    if (!result) {
                        this.workStatus = WorkStatus.OUT_OF_ENERGY;
                        return;
                    }
                    this.itemStackHandler.setStackInSlot(i, copy);
                    this.energyStorage.consumeEnergy(totalCost, false);
                    this.processResults(itemHandler, recipe, multiplier, false);
                }
                this.sortSlots();
            }
        }
    }

    private boolean processResults(IItemHandler itemHandler, CompactingRecipe recipe, int multiplier, boolean simulate) {
        ItemStack output = ItemStackUtil.multiplyStackCount(recipe.getOutput(), multiplier);
        ItemStack response = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate);
        if (!response.m_41619_()) {
            this.workStatus = WorkStatus.INVENTORY_FULL;
        }
        return this.workStatus == WorkStatus.WORKING;
    }
}

