/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.fakeplayer.MGUFakePlayer;
import mob_grinding_utils.items.ItemImaginaryInvisibleNotReallyThereSword;
import mob_grinding_utils.recipe.BeheadingRecipe;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EntityHeadDropEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        MGUFakePlayer fakePlayer;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getEntity().m_21223_() > 0.0f) {
            return;
        }
        int beheadingLevel = 0;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof MGUFakePlayer && (fakePlayer = (MGUFakePlayer)entity).m_21205_().m_41720_() instanceof ItemImaginaryInvisibleNotReallyThereSword) {
            ItemStack stack;
            int dropChance;
            ItemStack tempSword = fakePlayer.m_21205_();
            if (tempSword.m_41782_() && tempSword.m_41783_().m_128441_("beheadingValue")) {
                beheadingLevel = tempSword.m_41783_().m_128451_("beheadingValue");
            }
            if ((dropChance = event.getEntity().m_20193_().f_46441_.m_188503_(10)) < beheadingLevel && !(stack = EntityHeadDropEvent.getHeadFromEntity(event.getEntity())).m_41619_()) {
                this.addDrop(stack, event.getEntity(), event.getDrops());
            }
        }
    }

    public static ItemStack getHeadFromEntity(LivingEntity target) {
        if (target.m_6162_()) {
            return ItemStack.f_41583_;
        }
        Optional<BeheadingRecipe> recipeOptional = MobGrindingUtils.BEHEADING_RECIPES.stream().filter(recipe -> recipe.matches(target.m_6095_())).findFirst();
        if (recipeOptional.isPresent()) {
            return recipeOptional.get().m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        }
        if (target instanceof Mob && ModList.get().isLoaded("player_mobs") && EntityHeadDropEvent.isPlayerMob((Entity)target)) {
            return EntityHeadDropEvent.createHeadFor(EntityHeadDropEvent.getPlayerByUsername(target.m_7755_().getString()));
        }
        if (target instanceof Player) {
            return EntityHeadDropEvent.createHeadFor((Player)target);
        }
        return ItemStack.f_41583_;
    }

    public static boolean isPlayerMob(Entity entity) {
        Optional entityMob = EntityType.m_20632_((String)"player_mobs:player_mob");
        return entityMob.isPresent() && ((EntityType)entityMob.get()).equals(entity.m_6095_());
    }

    public static GameProfile getPlayerByUsername(String name) {
        return new GameProfile(null, name);
    }

    public static ItemStack createHeadFor(Player player) {
        return EntityHeadDropEvent.createHeadFor(player.m_36316_());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42680_, 1);
        stack.m_41751_(new CompoundTag());
        CompoundTag profileData = new CompoundTag();
        NbtUtils.m_129230_((CompoundTag)profileData, (GameProfile)profile);
        stack.m_41783_().m_128365_("SkullOwner", (Tag)profileData);
        return stack;
    }

    private void addDrop(ItemStack stack, LivingEntity entity, Collection<ItemEntity> collection) {
        if (stack.m_41613_() <= 0) {
            return;
        }
        ItemEntity entityItem = new ItemEntity(entity.m_20193_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
        entityItem.m_32060_();
        collection.add(entityItem);
    }
}

