/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import commoble.morered.MoreRed;
import commoble.morered.soldering.SolderingMenu;
import commoble.morered.soldering.SolderingRecipe;
import commoble.morered.soldering.SolderingRecipeButtonPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class SolderingScreen
extends AbstractContainerScreen<SolderingMenu> {
    public static final ResourceLocation TRADING_SCREEN = new ResourceLocation("minecraft:textures/gui/container/villager2.png");
    public static final ResourceLocation CRAFTING_SCREEN = new ResourceLocation("minecraft:textures/gui/container/crafting_table.png");
    public static final int SCROLLPANEL_X = 4;
    public static final int SCROLLPANEL_Y = 17;
    public static final int SCROLLPANEL_WIDTH = 97;
    public static final int SCROLLPANEL_HEIGHT = 142;
    private SolderingScrollPanel scrollPanel;

    public SolderingScreen(SolderingMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        int vanillaImageWidth = this.f_97726_;
        this.f_97726_ = 276;
        this.f_97727_ = 166;
        this.f_97730_ += this.f_97726_ - vanillaImageWidth;
    }

    public void m_7856_() {
        super.m_7856_();
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        ClientLevel world = this.f_96541_.f_91073_;
        ImmutableList recipes = world != null ? SolderingRecipe.getAllSolderingRecipes(world.m_7465_(), world.m_9598_()) : ImmutableList.of();
        this.scrollPanel = new SolderingScrollPanel(this.f_96541_, this, (List<Recipe<CraftingContainer>>)recipes, xStart + 4, yStart + 17, 97, 142);
        this.m_7787_(this.scrollPanel);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollPanel != null) {
            this.scrollPanel.m_88315_(graphics, mouseX, mouseY, 0.0f);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public void renderItemStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.m_280203_(stack, x, y);
        graphics.m_280370_(this.f_96547_, stack, x, y);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((SolderingMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            graphics.m_280153_(this.f_96547_, this.f_97734_.m_7993_(), mouseX, mouseY);
        } else if (this.scrollPanel != null && !this.scrollPanel.tooltipItem.m_41619_()) {
            graphics.m_280153_(this.f_96547_, this.scrollPanel.tooltipItem, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280163_(TRADING_SCREEN, xStart, yStart, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        int arrowU = 186;
        int arrowV = 36;
        int arrowWidth = 14;
        int arrowHeight = 18;
        int tiles = 4;
        int arrowScreenX = xStart + arrowU - tiles * arrowWidth;
        int arrowScreenY = yStart + arrowV;
        int blitWidth = arrowWidth * tiles;
        graphics.m_280411_(TRADING_SCREEN, arrowScreenX, arrowScreenY, blitWidth, arrowHeight, (float)arrowU, (float)arrowV, arrowWidth, arrowHeight, 512, 256);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.scrollPanel.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static class SolderingScrollPanel
    extends ScrollPanel
    implements GuiEventListener {
        private List<RecipeButton> buttons = new ArrayList<RecipeButton>();
        public ItemStack tooltipItem = ItemStack.f_41583_;
        public final int totalButtonHeight;

        public SolderingScrollPanel(Minecraft client, SolderingScreen screen, List<Recipe<CraftingContainer>> recipes, int left, int top, int width, int height) {
            super(client, width, height, top, left);
            int buttonWidth = 90;
            int totalButtonHeight = 0;
            ClientLevel world = client.f_91073_;
            if (world != null) {
                for (Recipe<CraftingContainer> recipe : SolderingRecipe.getAllSolderingRecipes(world.m_7465_(), world.m_9598_())) {
                    RecipeButton recipeButton = new RecipeButton(screen, recipe, left, top + totalButtonHeight, buttonWidth);
                    this.buttons.add(recipeButton);
                    totalButtonHeight += recipeButton.m_93694_();
                }
            }
            this.totalButtonHeight = totalButtonHeight;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.buttons;
        }

        protected int getContentHeight() {
            return this.totalButtonHeight;
        }

        protected void drawPanel(GuiGraphics graphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            this.tooltipItem = ItemStack.f_41583_;
            for (RecipeButton button : this.buttons) {
                button.scrollButton((int)this.scrollDistance);
                button.m_88315_(graphics, mouseX, mouseY, 0.0f);
                if (button.tooltipItem.m_41619_()) continue;
                this.tooltipItem = button.tooltipItem;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return super.m_6375_(mouseX, mouseY, button);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }

    public static class RecipeButton
    extends ExtendedButton {
        private final int baseY;
        private final SolderingScreen screen;
        private final Recipe<CraftingContainer> recipe;
        public ItemStack tooltipItem = ItemStack.f_41583_;

        public RecipeButton(SolderingScreen screen, Recipe<CraftingContainer> recipe, int x, int y, int width) {
            super(x, y, width, RecipeButton.getHeightForRecipe(recipe), (Component)Component.m_237113_((String)""), button -> RecipeButton.onButtonClicked((SolderingMenu)screen.f_97732_, recipe));
            this.baseY = y;
            this.screen = screen;
            this.recipe = recipe;
        }

        public static void onButtonClicked(SolderingMenu container, Recipe<CraftingContainer> recipe) {
            MoreRed.CHANNEL.sendToServer((Object)new SolderingRecipeButtonPacket(recipe.m_6423_()));
            container.attemptRecipeAssembly(Optional.of(recipe));
        }

        public static int getHeightForRecipe(Recipe<?> recipe) {
            int rows = 1 + (recipe.m_7527_().size() - 1) / 3;
            return rows * 18 + 5;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return false;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.tooltipItem = ItemStack.f_41583_;
            if (this.f_93624_) {
                int thisX = this.m_252754_();
                int thisY = this.m_252907_();
                super.m_87963_(graphics, mouseX, mouseY, partial);
                NonNullList ingredients = this.recipe.m_7527_();
                int ingredientCount = ingredients.size();
                for (int ingredientIndex = 0; ingredientIndex < ingredientCount; ++ingredientIndex) {
                    ItemStack stack = RecipeButton.getIngredientVariant(((Ingredient)ingredients.get(ingredientIndex)).m_43908_());
                    int itemRow = ingredientIndex / 3;
                    int itemColumn = ingredientIndex % 3;
                    int itemOffsetX = 2 + itemColumn * 18;
                    int itemOffsetY = 2 + itemRow * 18;
                    int itemX = thisX + itemOffsetX;
                    int itemY = thisY + itemOffsetY;
                    int itemEndX = itemX + 18;
                    int itemEndY = itemY + 18;
                    this.screen.renderItemStack(graphics, stack, itemX, itemY);
                    if (mouseX < itemX || mouseX >= itemEndX || mouseY < itemY || mouseY >= itemEndY) continue;
                    this.tooltipItem = stack;
                }
                if (ingredientCount > 0) {
                    int extraIngredientRows = (ingredientCount - 1) / 3;
                    int arrowX = thisX + 2 + 54 + 4;
                    int arrowY = thisY + 2 + 4 + 9 * extraIngredientRows;
                    int arrowWidth = 10;
                    int arrowHeight = 9;
                    int arrowU = 15;
                    int arrowV = 171;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TRADING_SCREEN);
                    graphics.m_280163_(TRADING_SCREEN, arrowX, arrowY, (float)arrowU, (float)arrowV, arrowWidth, arrowHeight, 512, 256);
                    ItemStack outputStack = this.recipe.m_8043_(((SolderingScreen)this.screen).f_96541_.f_91073_.m_9598_());
                    if (!outputStack.m_41619_()) {
                        int itemX = thisX + 2 + 72;
                        int itemY = thisY + 2 + 9 * extraIngredientRows;
                        int itemEndX = itemX + 18;
                        int itemEndY = itemY + 18;
                        this.screen.renderItemStack(graphics, outputStack, itemX, itemY);
                        if (mouseX >= itemX && mouseX < itemEndX && mouseY >= itemY && mouseY < itemEndY) {
                            this.tooltipItem = outputStack;
                        }
                    }
                }
            }
        }

        public static ItemStack getIngredientVariant(ItemStack[] variants) {
            int variantCount = variants.length;
            if (variantCount > 0) {
                int variantIndex = (int)(Util.m_137550_() / 1000L / (long)variantCount);
                return variants[Mth.m_14045_((int)variantIndex, (int)0, (int)(variantCount - 1))];
            }
            return ItemStack.f_41583_;
        }

        public void scrollButton(int currentScrollAmount) {
            this.m_253211_(this.baseY - currentScrollAmount);
        }

        public void onClickButton() {
        }
    }
}

