/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import com.google.common.collect.ImmutableSet;
import com.mojang.math.OctahedralGroup;
import commoble.morered.MoreRed;
import commoble.morered.util.EightGroup;
import commoble.morered.util.NBTListCodec;
import commoble.morered.util.NestedBoundingBox;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class WirePostBlockEntity
extends BlockEntity {
    public static final String CONNECTIONS = "connections";
    public static final AABB EMPTY_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private Map<BlockPos, NestedBoundingBox> remoteConnections = new HashMap<BlockPos, NestedBoundingBox>();
    private AABB renderAABB = EMPTY_AABB;
    public static final NBTListCodec<BlockPos, CompoundTag> BLOCKPOS_LISTER = new NBTListCodec<BlockPos, CompoundTag>("connections", NBTListCodec.ListTagType.COMPOUND, NbtUtils::m_129224_, NbtUtils::m_129239_);

    public WirePostBlockEntity(BlockEntityType<? extends WirePostBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public WirePostBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoreRed.get().redwirePostBeType.get(), pos, state);
    }

    public static boolean addConnection(LevelAccessor world, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = world.m_7702_(posA);
        if (blockEntity instanceof WirePostBlockEntity) {
            WirePostBlockEntity postA = (WirePostBlockEntity)blockEntity;
            blockEntity = world.m_7702_(posB);
            if (blockEntity instanceof WirePostBlockEntity) {
                WirePostBlockEntity postB = (WirePostBlockEntity)blockEntity;
                return WirePostBlockEntity.addConnection(world, postA, postB);
            }
        }
        return false;
    }

    public static boolean addConnection(LevelAccessor world, @Nonnull WirePostBlockEntity postA, @Nonnull WirePostBlockEntity postB) {
        postA.addConnection(postB.f_58858_);
        postB.addConnection(postA.f_58858_);
        return true;
    }

    public void setConnectionsRaw(Map<BlockPos, NestedBoundingBox> connections) {
        this.remoteConnections = connections;
    }

    public Set<BlockPos> getRemoteConnections() {
        return ImmutableSet.copyOf(this.remoteConnections.keySet());
    }

    public Map<BlockPos, NestedBoundingBox> getRemoteConnectionBoxes() {
        return this.remoteConnections;
    }

    public boolean hasRemoteConnection(BlockPos otherPos) {
        return this.remoteConnections.keySet().contains(otherPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean arePostsConnected(LevelAccessor level, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = level.m_7702_(posA);
        if (!(blockEntity instanceof WirePostBlockEntity)) return false;
        WirePostBlockEntity postA = (WirePostBlockEntity)blockEntity;
        blockEntity = level.m_7702_(posB);
        if (!(blockEntity instanceof WirePostBlockEntity)) return false;
        WirePostBlockEntity postB = (WirePostBlockEntity)blockEntity;
        if (!postA.hasRemoteConnection(posB)) return false;
        if (!postB.hasRemoteConnection(posA)) return false;
        return true;
    }

    public void clearRemoteConnections() {
        for (BlockPos otherPos : this.remoteConnections.keySet()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(otherPos);
            if (!(blockEntity instanceof WirePostBlockEntity)) continue;
            WirePostBlockEntity otherPost = (WirePostBlockEntity)blockEntity;
            otherPost.removeConnection(this.f_58858_);
        }
        this.remoteConnections = new HashMap<BlockPos, NestedBoundingBox>();
        this.onCommonDataUpdated();
    }

    public static void removeConnection(LevelAccessor world, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = world.m_7702_(posA);
        if (blockEntity instanceof WirePostBlockEntity) {
            WirePostBlockEntity postA = (WirePostBlockEntity)blockEntity;
            postA.removeConnection(posB);
        }
        if ((blockEntity = world.m_7702_(posB)) instanceof WirePostBlockEntity) {
            WirePostBlockEntity postB = (WirePostBlockEntity)blockEntity;
            postB.removeConnection(posA);
        }
    }

    private void addConnection(BlockPos otherPos) {
        this.remoteConnections.put(otherPos.m_7949_(), this.getNestedBoundingBoxForConnectedPos(otherPos));
        this.f_58857_.m_46586_(this.f_58858_, this.m_58900_().m_60734_(), otherPos);
        this.onCommonDataUpdated();
    }

    private void removeConnection(BlockPos otherPos) {
        int otherY;
        int thisY;
        this.remoteConnections.remove(otherPos);
        this.f_58857_.m_46586_(this.f_58858_, this.m_58900_().m_60734_(), otherPos);
        if (!this.f_58857_.f_46443_ && ((thisY = this.f_58858_.m_123342_()) < (otherY = otherPos.m_123342_()) || thisY == otherY && this.f_58858_.hashCode() < otherPos.hashCode())) {
            MoreRed.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new WireBreakPacket(WirePostBlockEntity.getConnectionVector(this.f_58858_), WirePostBlockEntity.getConnectionVector(otherPos)));
        }
        this.onCommonDataUpdated();
    }

    public void notifyConnections() {
        this.getRemoteConnections().forEach(connectionPos -> this.f_58857_.m_46586_(connectionPos, this.m_58900_().m_60734_(), this.f_58858_));
    }

    public static Vec3 getConnectionVector(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.renderAABB;
    }

    public static AABB getAABBContainingAllBlockPos(BlockPos startPos, Set<BlockPos> theRest) {
        return theRest.stream().map(AABB::new).reduce(EMPTY_AABB, AABB::m_82367_, AABB::m_82367_).m_82367_(new AABB(startPos));
    }

    public void onCommonDataUpdated() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readCommonData(compound);
    }

    protected void readCommonData(CompoundTag compound) {
        if (compound.m_128441_(CONNECTIONS)) {
            List<BlockPos> normalizedPositions = BLOCKPOS_LISTER.read(compound);
            ArrayList<BlockPos> absolutePositions = new ArrayList<BlockPos>();
            for (BlockPos normalPos : normalizedPositions) {
                absolutePositions.add(this.denormalizePos(normalPos));
            }
            HashMap<BlockPos, NestedBoundingBox> newMap = new HashMap<BlockPos, NestedBoundingBox>();
            absolutePositions.forEach(otherPos -> newMap.put((BlockPos)otherPos, this.getNestedBoundingBoxForConnectedPos((BlockPos)otherPos)));
            this.remoteConnections = newMap;
        }
        this.renderAABB = WirePostBlockEntity.getAABBContainingAllBlockPos(this.f_58858_, this.remoteConnections.keySet());
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ArrayList<BlockPos> normalizedPositions = new ArrayList<BlockPos>();
        for (BlockPos absolutePos : this.remoteConnections.keySet()) {
            normalizedPositions.add(this.normalizePos(absolutePos));
        }
        BLOCKPOS_LISTER.write(normalizedPositions, compound);
    }

    public BlockPos normalizePos(BlockPos absolutePos) {
        BlockPos relativePos = absolutePos.m_121996_((Vec3i)this.m_58899_());
        OctahedralGroup normalizer = ((OctahedralGroup)this.m_58900_().m_61143_((Property)WirePostBlock.TRANSFORM)).m_174944_();
        BlockPos normalizedPos = EightGroup.transform(relativePos, normalizer);
        return normalizedPos;
    }

    public BlockPos denormalizePos(BlockPos normalPos) {
        OctahedralGroup denormalizer = (OctahedralGroup)this.m_58900_().m_61143_((Property)WirePostBlock.TRANSFORM);
        BlockPos relativePos = EightGroup.transform(normalPos, denormalizer);
        BlockPos absolutePos = relativePos.m_121955_((Vec3i)this.m_58899_());
        return absolutePos;
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        this.m_183515_(compound);
        return compound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public NestedBoundingBox getNestedBoundingBoxForConnectedPos(BlockPos otherPos) {
        Vec3 thisVec = WirePostBlockEntity.getConnectionVector(this.f_58858_);
        Vec3 otherVec = WirePostBlockEntity.getConnectionVector(otherPos);
        boolean otherHigher = otherVec.f_82480_ > thisVec.f_82480_;
        Vec3 higherVec = otherHigher ? otherVec : thisVec;
        Vec3 lowerVec = otherHigher ? thisVec : otherVec;
        Vec3[] points = SlackInterpolator.getInterpolatedPoints(lowerVec, higherVec);
        int segmentCount = points.length - 1;
        AABB[] boxes = new AABB[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            boxes[i] = new AABB(points[i], points[i + 1]);
        }
        return NestedBoundingBox.fromAABBs(boxes);
    }
}

