/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.validated;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.ValidationException;
import net.roguelogix.phosphophyllite.multiblock.modular.IModularMultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock.validated.IAssembledTickMultiblockModule;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblockTile;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;

@NonnullDefault
public interface IValidatedMultiblock<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IModularMultiblockController<TileType, BlockType, ControllerType> {
    default public Module<TileType, BlockType, ControllerType> validatedModule() {
        return this.module(IValidatedMultiblock.class, Module.class);
    }

    default public AssemblyState assemblyState() {
        return this.validatedModule().assemblyState;
    }

    default public void requestValidation() {
        this.validatedModule().requestValidation();
    }

    default public void validateStage1() throws ValidationException {
    }

    default public void validateStage2() throws ValidationException {
    }

    default public void validateStage3() throws ValidationException {
    }

    default public void transitionToState(AssemblyState newAssemblyState) {
        this.validatedModule().transitionToState(newAssemblyState);
    }

    default public void onStateTransition(AssemblyState oldAssemblyState, AssemblyState newAssemblyState) {
        block0 : switch (oldAssemblyState) {
            case ASSEMBLED: {
                switch (newAssemblyState) {
                    case DISASSEMBLED: {
                        this.onDisassembled();
                        break;
                    }
                    case ASSEMBLED: {
                        this.onReassembled();
                    }
                }
                break;
            }
            case DISASSEMBLED: {
                switch (newAssemblyState) {
                    case ASSEMBLED: {
                        this.onAssembled();
                        break block0;
                    }
                    case DISASSEMBLED: {
                        this.onRedisassembled();
                    }
                }
            }
        }
    }

    default public void onAssembled() {
    }

    default public void onReassembled() {
    }

    default public void onDisassembled() {
    }

    default public void onRedisassembled() {
    }

    default public void tick() {
    }

    default public void disassembledTick() {
    }

    public static class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends MultiblockControllerModule<TileType, BlockType, ControllerType> {
        protected AssemblyState assemblyState = AssemblyState.DISASSEMBLED;
        private long updateAssemblyAtTick = Long.MAX_VALUE;
        @Nullable
        protected ValidationException lastValidationError = null;
        private final ObjectArrayList<IAssembledTickMultiblockModule> assembledTickMultiblockModules = new ObjectArrayList();
        private final ObjectArrayList<IValidatedMultiblockControllerModule> validatedMultiblockModules = new ObjectArrayList();
        private final Long2ObjectLinkedOpenHashMap<BlockState> newStates = new Long2ObjectLinkedOpenHashMap();

        @OnModLoad
        public static void register() {
            MultiblockControllerModuleRegistry.registerModule(IValidatedMultiblock.class, Module::new);
        }

        public Module(IValidatedMultiblock<TileType, BlockType, ControllerType> controller) {
            super(controller);
        }

        @Override
        public void postModuleConstruction() {
            for (MultiblockControllerModule value : this.modules()) {
                Object module;
                if (value instanceof IAssembledTickMultiblockModule) {
                    module = (IAssembledTickMultiblockModule)((Object)value);
                    this.assembledTickMultiblockModules.add(module);
                }
                if (!(value instanceof IValidatedMultiblockControllerModule)) continue;
                module = (IValidatedMultiblockControllerModule)((Object)value);
                this.validatedMultiblockModules.add(module);
            }
        }

        @Override
        public void split(List<ControllerType> others) {
            this.updateAssemblyAtTick = Long.MIN_VALUE;
        }

        @Override
        public void merge(ControllerType other) {
            this.disassembledBlockStates();
            this.updateAssemblyAtTick = Long.MIN_VALUE;
        }

        @Override
        public void onPartAdded(@Nonnull TileType tile) {
            this.requestValidation();
        }

        @Override
        public void onPartRemoved(@Nonnull TileType tile) {
            this.requestValidation();
        }

        public void requestValidation() {
            this.updateAssemblyAtTick = Phosphophyllite.tickNumber() + 1L;
        }

        private void updateAssemblyState() {
            if (this.updateAssemblyAtTick > Phosphophyllite.tickNumber()) {
                return;
            }
            this.updateAssemblyAtTick = Long.MAX_VALUE;
            for (IValidatedMultiblockControllerModule tileTypeControllerTypeMultiblockControllerModule : this.validatedMultiblockModules) {
                if (tileTypeControllerTypeMultiblockControllerModule.canValidate()) continue;
                return;
            }
            this.lastValidationError = null;
            try {
                for (IValidatedMultiblockControllerModule tileTypeControllerTypeMultiblockControllerModule : this.validatedMultiblockModules) {
                    tileTypeControllerTypeMultiblockControllerModule.validateStage1();
                }
                ((IValidatedMultiblock)((Object)this.controller)).validateStage1();
                for (IValidatedMultiblockControllerModule tileTypeControllerTypeMultiblockControllerModule : this.validatedMultiblockModules) {
                    tileTypeControllerTypeMultiblockControllerModule.validateStage2();
                }
                ((IValidatedMultiblock)((Object)this.controller)).validateStage2();
                for (IValidatedMultiblockControllerModule tileTypeControllerTypeMultiblockControllerModule : this.validatedMultiblockModules) {
                    tileTypeControllerTypeMultiblockControllerModule.validateStage3();
                }
                ((IValidatedMultiblock)((Object)this.controller)).validateStage3();
            }
            catch (ValidationException validationError) {
                this.lastValidationError = validationError;
            }
            this.transitionToState(this.lastValidationError == null ? AssemblyState.ASSEMBLED : AssemblyState.DISASSEMBLED);
        }

        public final void transitionToState(AssemblyState newAssemblyState) {
            switch (newAssemblyState) {
                case ASSEMBLED: {
                    this.assembledBlockStates();
                    break;
                }
                case DISASSEMBLED: {
                    this.disassembledBlockStates();
                }
            }
            AssemblyState oldAssemblyState = this.assemblyState;
            for (IValidatedMultiblockControllerModule module : this.validatedMultiblockModules) {
                module.onStateTransition(oldAssemblyState, newAssemblyState);
            }
            ((IValidatedMultiblock)((Object)this.controller)).onStateTransition(oldAssemblyState, newAssemblyState);
            this.assemblyState = newAssemblyState;
        }

        private void assembledBlockStates() {
            this.newStates.clear();
            int size = this.controller.blocks.size();
            BlockEntity[] tileElements = this.controller.blocks.tileElements();
            long[] posElements = this.controller.blocks.posElements();
            if (tileElements.length < size || posElements.length < size) {
                throw new IllegalStateException("Arrays too short");
            }
            for (int i = 0; i < size; ++i) {
                BlockEntity entity = tileElements[i];
                IValidatedMultiblockTile.Module module = ((IValidatedMultiblockTile)entity).validatedModule();
                long pos = posElements[i];
                BlockState oldState = entity.m_58900_();
                BlockState newState = module.assembledBlockState(oldState);
                if (newState == oldState) continue;
                this.newStates.put(pos, (Object)newState);
                entity.m_155250_(newState);
            }
            if (!this.newStates.isEmpty()) {
                Util.setBlockStates(this.newStates, this.controller.level);
            }
        }

        private void disassembledBlockStates() {
            this.newStates.clear();
            int size = this.controller.blocks.size();
            BlockEntity[] tileElements = this.controller.blocks.tileElements();
            long[] posElements = this.controller.blocks.posElements();
            if (tileElements.length < size || posElements.length < size) {
                throw new IllegalStateException("Arrays too short");
            }
            for (int i = 0; i < size; ++i) {
                BlockEntity entity = tileElements[i];
                IValidatedMultiblockTile.Module module = ((IValidatedMultiblockTile)entity).validatedModule();
                long pos = posElements[i];
                BlockState oldState = entity.m_58900_();
                BlockState newState = module.disassembledBlockState(oldState);
                if (newState == oldState) continue;
                this.newStates.put(pos, (Object)newState);
                entity.m_155250_(newState);
            }
            if (!this.newStates.isEmpty()) {
                Util.setBlockStates(this.newStates, this.controller.level);
            }
        }

        @Override
        public void update() {
            this.updateAssemblyState();
            for (IValidatedMultiblockControllerModule tileTypeControllerTypeMultiblockControllerModule : this.validatedMultiblockModules) {
                if (tileTypeControllerTypeMultiblockControllerModule.canTick()) continue;
                return;
            }
            if (this.assemblyState == AssemblyState.ASSEMBLED) {
                this.assembledTickMultiblockModules.forEach(IAssembledTickMultiblockModule::preTick);
                ((IValidatedMultiblock)((Object)this.controller)).tick();
                this.assembledTickMultiblockModules.forEach(IAssembledTickMultiblockModule::postTick);
            } else if (this.assemblyState == AssemblyState.DISASSEMBLED) {
                this.assembledTickMultiblockModules.forEach(IAssembledTickMultiblockModule::preDisassembledTick);
                ((IValidatedMultiblock)((Object)this.controller)).disassembledTick();
                this.assembledTickMultiblockModules.forEach(IAssembledTickMultiblockModule::postDisassembledTick);
            }
        }

        @Override
        @Nullable
        public DebugInfo getDebugInfo() {
            DebugInfo debugInfo = new DebugInfo("ValidatedMultiblock");
            debugInfo.add("AssemblyState: " + this.assemblyState);
            debugInfo.add("LastValidationError: " + this.lastValidationError);
            return debugInfo;
        }
    }

    public static enum AssemblyState {
        ASSEMBLED,
        DISASSEMBLED;

    }
}

