/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.item;

import com.breakinblocks.plonk.common.config.PlonkConfig;
import com.breakinblocks.plonk.common.registry.RegistryBlocks;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class ItemBlockPlacedItems
extends BlockItem {
    private static final String TAG_HELD = "Held";
    private static final String TAG_RENDER_TYPE = "RenderType";

    public ItemBlockPlacedItems(Item.Properties builder) {
        super((Block)RegistryBlocks.placed_items, builder);
    }

    public void setHeldStack(ItemStack stack, ItemStack held, int renderType) {
        CompoundTag tagCompound = stack.m_41784_();
        CompoundTag tagCompoundHeld = tagCompound.m_128469_(TAG_HELD);
        held.m_41739_(tagCompoundHeld);
        tagCompound.m_128365_(TAG_HELD, (Tag)tagCompoundHeld);
        tagCompound.m_128405_(TAG_RENDER_TYPE, renderType);
        stack.m_41751_(tagCompound);
    }

    public ItemStack getHeldStack(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_(TAG_HELD)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_(TAG_HELD));
    }

    public int getHeldRenderType(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_(TAG_RENDER_TYPE)) {
            return 0;
        }
        return tagCompound.m_128451_(TAG_RENDER_TYPE);
    }

    protected boolean tryInsertStack(UseOnContext context, TilePlacedItems tile) {
        ItemStack heldItem = this.getHeldStack(context.m_43722_());
        int renderType = this.getHeldRenderType(context.m_43722_());
        ItemStack remainder = tile.insertStack(heldItem, renderType);
        tile.m_6596_();
        tile.clean();
        if (remainder != heldItem) {
            this.setHeldStack(context.m_43722_(), remainder, renderType);
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack heldStack = this.getHeldStack(context.m_43722_());
        if (heldStack.m_41619_() || !PlonkConfig.canPlace(heldStack)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        TilePlacedItems tile = null;
        if (world.m_8055_(pos).m_60734_() == RegistryBlocks.placed_items) {
            tile = (TilePlacedItems)world.m_7702_(pos);
        } else {
            BlockPos pos2 = pos.m_121945_(facing);
            if (world.m_8055_(pos2).m_60734_() == RegistryBlocks.placed_items) {
                tile = (TilePlacedItems)world.m_7702_(pos2);
            }
        }
        Player player = context.m_43723_();
        if (tile != null && this.tryInsertStack(context, tile)) {
            BlockState state = world.m_8055_(pos);
            SoundType soundtype = state.m_60734_().getSoundType(state, (LevelReader)world, pos, (Entity)player);
            world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public boolean m_7429_(BlockPlaceContext context, BlockState newState) {
        ItemStack heldStack = this.getHeldStack(context.m_43722_());
        if (heldStack.m_41619_()) {
            return false;
        }
        if (!super.m_7429_(context, newState)) {
            return false;
        }
        TilePlacedItems tile = (TilePlacedItems)context.m_43725_().m_7702_(context.m_8083_());
        if (tile == null) {
            return false;
        }
        return this.tryInsertStack((UseOnContext)context, tile);
    }
}

