/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelTransferGadget;
import me.desht.pneumaticcraft.client.render.entity.semiblock.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.TransferGadgetEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderTransferGadget
extends RenderSemiblockBase<TransferGadgetEntity> {
    private final ModelTransferGadget model;

    public RenderTransferGadget(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new ModelTransferGadget(ctx.m_174023_(PNCModelLayers.TRANSFER_GADGET));
    }

    public void render(TransferGadgetEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction side;
        if (entity.isAir()) {
            return;
        }
        matrixStackIn.m_85836_();
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        matrixStackIn.m_85837_(0.0, (side = entity.getSide()).m_122434_() == Direction.Axis.Y ? 1.2 : -1.1, 0.0);
        switch (side) {
            case UP: {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                matrixStackIn.m_85837_(-1.1, -1.1, 0.0);
                break;
            }
            case DOWN: {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                matrixStackIn.m_85837_(1.3, -1.1, 0.0);
                break;
            }
            case NORTH: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
        }
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_7695_(matrixStackIn, builder, this.kludgeLightingLevel(entity, packedLightIn), OverlayTexture.m_118090_((float)0.0f, (boolean)false), 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    public Vec3 getRenderOffset(TransferGadgetEntity entityIn, float partialTicks) {
        VoxelShape shape = entityIn.getBlockState().m_60808_((BlockGetter)entityIn.getWorld(), entityIn.getBlockPos());
        double yOff = (shape.m_83297_(Direction.Axis.Y) - shape.m_83288_(Direction.Axis.Y)) / 2.0;
        return switch (entityIn.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(0.0, shape.m_83288_(Direction.Axis.Y), 0.0);
            case Direction.UP -> new Vec3(0.0, shape.m_83297_(Direction.Axis.Y), 0.0);
            case Direction.NORTH -> new Vec3(0.0, yOff, shape.m_83288_(Direction.Axis.Z) - 0.6);
            case Direction.SOUTH -> new Vec3(0.0, yOff, shape.m_83297_(Direction.Axis.Z) - 0.4);
            case Direction.WEST -> new Vec3(shape.m_83288_(Direction.Axis.X) - 0.6, yOff, 0.0);
            case Direction.EAST -> new Vec3(shape.m_83297_(Direction.Axis.X) - 0.4, yOff, 0.0);
        };
    }

    public ResourceLocation getTextureLocation(TransferGadgetEntity entityTransferGadget) {
        return entityTransferGadget.getIOMode().getTexture();
    }
}

