/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.RefineryOutputBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class RefineryOutputBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)14.5, (double)14.5, (double)12.0, (double)15.5), Block.m_49796_((double)12.0, (double)1.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), Block.m_49796_((double)3.0, (double)1.0, (double)14.0, (double)4.0, (double)13.0, (double)16.0), Block.m_49796_((double)1.5, (double)11.0, (double)14.5, (double)3.0, (double)12.0, (double)15.5), Block.m_49796_((double)0.0, (double)10.0, (double)14.0, (double)2.0, (double)13.0, (double)16.0), Block.m_49796_((double)14.0, (double)10.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)14.5, (double)1.0, (double)14.5, (double)15.5, (double)15.0, (double)15.5), Block.m_49796_((double)14.5, (double)1.0, (double)0.5, (double)15.5, (double)15.0, (double)1.5), Block.m_49796_((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.m_49796_((double)1.5, (double)11.0, (double)0.5, (double)14.5, (double)12.0, (double)1.5), Block.m_49796_((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)16.0, (double)13.0), Block.m_49796_((double)4.0, (double)1.0, (double)13.0, (double)12.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.m_49796_((double)0.0, (double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)3.0), Block.m_49796_((double)0.0, (double)15.0, (double)6.0, (double)1.0, (double)16.0, (double)15.0), Block.m_49796_((double)15.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)7.0), Block.m_49796_((double)15.0, (double)15.0, (double)11.0, (double)16.0, (double)16.0, (double)15.0), Block.m_49796_((double)0.5, (double)11.0, (double)1.5, (double)1.5, (double)12.0, (double)14.5), Block.m_49796_((double)0.5, (double)1.0, (double)0.5, (double)1.5, (double)15.0, (double)1.5), Block.m_49796_((double)0.5, (double)1.0, (double)14.5, (double)1.5, (double)15.0, (double)15.5), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)13.0, (double)2.0), Block.m_49796_((double)14.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)11.0), Block.m_49796_((double)13.25, (double)7.5, (double)9.25, (double)14.25, (double)9.5, (double)11.25), Block.m_49796_((double)13.25, (double)7.5, (double)6.75, (double)14.25, (double)9.5, (double)8.75), Block.m_49796_((double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0, (double)6.0), Block.m_49796_((double)0.0, (double)3.5, (double)3.0, (double)2.0, (double)5.5, (double)6.0), Block.m_49796_((double)13.5, (double)8.0, (double)7.25, (double)15.5, (double)9.0, (double)8.25), Block.m_49796_((double)13.5, (double)8.0, (double)9.75, (double)15.5, (double)9.0, (double)10.75), Block.m_49796_((double)14.5, (double)1.0, (double)7.25, (double)15.5, (double)8.0, (double)8.25), Block.m_49796_((double)14.5, (double)1.0, (double)9.75, (double)15.5, (double)8.0, (double)10.75), Block.m_49796_((double)0.5, (double)1.0, (double)3.5, (double)2.5, (double)4.0, (double)5.5), Block.m_49796_((double)14.5, (double)11.0, (double)1.5, (double)15.5, (double)12.0, (double)14.5));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public RefineryOutputBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.REFINERY_OUTPUT.get()).map(te -> {
            RefineryControllerBlockEntity master;
            boolean canTransferFluid = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(hand), (int)1)).map(heldHandler -> FluidUtil.getFluidHandler((Level)world, (BlockPos)pos, (Direction)brtr.m_82434_()).map(refineryHandler -> this.couldTransferFluidOut((IFluidHandler)heldHandler, (IFluidHandler)refineryHandler)).orElse(false)).orElse(false);
            if (canTransferFluid) {
                return super.m_6227_(state, world, pos, player, hand, brtr);
            }
            if (!world.f_46443_ && (master = te.getRefineryController()) != null) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)master, (BlockPos)master.m_58899_());
            }
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    private boolean couldTransferFluidOut(IFluidHandler h1, IFluidHandler h2) {
        FluidStack f = FluidUtil.tryFluidTransfer((IFluidHandler)h1, (IFluidHandler)h2, (int)1000, (boolean)false);
        return !f.isEmpty();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.m_61143_((Property)this.directionProperty());
        return SHAPES[d.m_122416_()];
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        int nOutputs = 0;
        int up = 1;
        int down = 1;
        while (worldIn.m_8055_(pos.m_6630_(up++)).m_60734_() instanceof RefineryOutputBlock) {
            ++nOutputs;
        }
        while (worldIn.m_8055_(pos.m_6625_(down++)).m_60734_() instanceof RefineryOutputBlock) {
            ++nOutputs;
        }
        return nOutputs < 4 && super.m_7898_(state, worldIn, pos);
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!worldIn.m_5776_() && facingState.m_60734_() == ModBlocks.REFINERY_OUTPUT.get()) {
            this.recache(worldIn, currentPos);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void recache(LevelAccessor world, BlockPos pos) {
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, RefineryOutputBlockEntity.class).ifPresent(te -> {
            RefineryControllerBlockEntity teC = te.getRefineryController();
            if (teC != null) {
                teC.cacheRefineryOutputs();
            }
        });
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RefineryOutputBlockEntity(pPos, pState);
    }
}

