/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.Validate;

public class AirHandlerItemStack
extends IAirHandlerItem.Provider {
    public static final String AIR_NBT_KEY = "pneumaticcraft:air";
    private final LazyOptional<IAirHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack container;
    private final IPressurizableItem pressurizable;
    private int baseVolume;
    private final float maxPressure;

    public AirHandlerItemStack(ItemStack container) {
        Validate.isTrue((boolean)(container.m_41720_() instanceof IPressurizableItem), (String)("itemstack " + container + " must be an IPressurizableItem!"), (Object[])new Object[0]);
        this.container = container;
        this.pressurizable = (IPressurizableItem)container.m_41720_();
        this.baseVolume = this.pressurizable.getBaseVolume();
        this.maxPressure = this.pressurizable.getMaxPressure();
    }

    @Override
    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public float getPressure() {
        float pressure = this.pressurizable.getPressure(this.container);
        if (pressure > this.maxPressure) {
            this.container.m_41784_().m_128405_(AIR_NBT_KEY, (int)(this.maxPressure * (float)this.getVolume()));
            return this.maxPressure;
        }
        return pressure;
    }

    @Override
    public int getAir() {
        return this.pressurizable.getAir(this.container);
    }

    @Override
    public void addAir(int amount) {
        if (this.container.m_41613_() != 1) {
            return;
        }
        int currentAir = this.getAir();
        int newAir = currentAir + amount;
        if (newAir != 0) {
            this.container.m_41784_().m_128405_(AIR_NBT_KEY, currentAir + amount);
        } else if (this.container.m_41782_()) {
            Objects.requireNonNull(this.container.m_41783_()).m_128473_(AIR_NBT_KEY);
            if (this.container.m_41783_().m_128456_()) {
                this.container.m_41751_(null);
            }
        }
    }

    @Override
    public int getBaseVolume() {
        return this.baseVolume;
    }

    @Override
    public void setBaseVolume(int newBaseVolume) {
        this.baseVolume = newBaseVolume;
    }

    @Override
    public int getVolume() {
        return this.pressurizable.getEffectiveVolume(this.container);
    }

    @Override
    public float maxPressure() {
        return this.maxPressure;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

