/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class ModCommands {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"pneumaticcraft");
    private static final RegistryObject<SingletonArgumentInfo<VarnameType>> VARNAME_COMMAND_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register("varname", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(VarnameType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(VarnameType::new)));
    private static final ResourceLocation UNKNOWN_ITEM = PneumaticRegistry.RL("unknown");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pncr").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump_nbt").requires(cs -> cs.m_6761_(2))).executes(ModCommands::dumpNBT))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"global_var").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"varname", (ArgumentType)new VarnameType()).suggests(ModCommands::suggestVarNames).executes(c -> ModCommands.getGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname")))))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"varname", (ArgumentType)new VarnameType()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> ModCommands.setGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname"), (Either<BlockPos, ItemInput>)Either.left((Object)BlockPosArgument.m_118242_((CommandContext)c, (String)"pos")))))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(c -> ModCommands.setGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname"), (Either<BlockPos, ItemInput>)Either.right((Object)ItemArgument.m_120963_((CommandContext)c, (String)"item")))))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"varname", (ArgumentType)StringArgumentType.greedyString()).suggests(ModCommands::suggestVarNames).executes(c -> ModCommands.delGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname")))))).then(Commands.m_82127_((String)"list").executes(ModCommands::listGlobalVars)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"amadrone_deliver").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"toPos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"fromPos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ModCommands.amadroneDeliver((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"toPos"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"fromPos")))))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"fromPos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ModCommands.amadroneDeliver((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player").m_20183_(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"fromPos"))))))).then(Commands.m_82127_((String)"armor_upgrade").then(Commands.m_82129_((String)"upgrade", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> ModCommands.suggestUpgradeIDs(builder)).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ModCommands.setArmorUpgrade((CommandSourceStack)ctx.getSource(), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"upgrade"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enabled")))))));
    }

    private static int setArmorUpgrade(CommandSourceStack source, ResourceLocation id, boolean enabled) throws CommandSyntaxException {
        Optional<IArmorUpgradeHandler<?>> upgrade = CommonArmorRegistry.getInstance().getArmorUpgradeHandler(id);
        if (upgrade.isPresent()) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)source.m_81375_());
            if (handler.upgradeUsable(upgrade.get(), false)) {
                handler.setUpgradeEnabled(upgrade.get(), enabled);
                source.m_288197_(() -> Component.m_237113_((String)(id + " enabled = " + enabled)), false);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Upgrade " + id + " is not inserted!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Unknown upgrade ID: " + id)).m_130940_(ChatFormatting.RED));
        return 0;
    }

    private static CompletableFuture<Suggestions> suggestUpgradeIDs(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(ArmorUpgradeRegistry.getInstance().getKnownUpgradeIds(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestVarNames(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Collection<String> varNames = GlobalVariableManager.getInstance().getAllActiveVariableNames((Player)((CommandSourceStack)ctx.getSource()).m_230896_());
        return SharedSuggestionProvider.m_82970_(varNames, (SuggestionsBuilder)builder);
    }

    private static int dumpNBT(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_81373_() instanceof Player) {
            ItemStack held = ((Player)source.m_81373_()).m_21205_();
            if (held.m_41783_() == null) {
                source.m_81352_((Component)Component.m_237113_((String)"No NBT"));
                return 0;
            }
            if (held.m_41783_().m_128456_()) {
                source.m_81352_((Component)Component.m_237113_((String)"Empty NBT"));
                return 0;
            }
            source.m_288197_(() -> Component.m_237113_((String)held.m_41783_().toString()), false);
            return 1;
        }
        return 0;
    }

    private static int amadroneDeliver(CommandSourceStack source, BlockPos toPos, BlockPos fromPos) {
        BlockEntity te = source.m_81372_().m_7702_(fromPos);
        int status = IOHelper.getInventoryForTE(te).map(inv -> {
            ArrayList<ItemStack> deliveredStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.getSlots() && deliveredStacks.size() < 36; ++i) {
                if (inv.getStackInSlot(i).m_41619_()) continue;
                deliveredStacks.add(inv.getStackInSlot(i));
            }
            if (deliveredStacks.size() > 0) {
                GlobalPos gPos = GlobalPosHelper.makeGlobalPos((Level)source.m_81372_(), toPos);
                PneumaticRegistry.getInstance().getDroneRegistry().deliverItemsAmazonStyle(gPos, deliveredStacks.toArray(new ItemStack[0]));
                source.m_288197_(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.success", PneumaticCraftUtils.posToString(fromPos), PneumaticCraftUtils.posToString(toPos)), false);
                return 1;
            }
            source.m_81352_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.noItems", PneumaticCraftUtils.posToString(fromPos)));
            return 0;
        }).orElse(-1);
        if (status == -1) {
            source.m_81352_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.noInventory", PneumaticCraftUtils.posToString(fromPos)));
        }
        return status;
    }

    private static int listGlobalVars(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Player playerEntity = source.m_81373_() instanceof Player ? (Player)source.m_81373_() : null;
        UUID id = playerEntity == null ? null : playerEntity.m_20148_();
        Collection<String> varNames = GlobalVariableManager.getInstance().getAllActiveVariableNames(playerEntity);
        source.m_288197_(() -> Component.m_237113_((String)(varNames.size() + " vars")).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}), false);
        varNames.stream().sorted().forEach(var -> {
            BlockPos pos = GlobalVariableHelper.getPos(id, var);
            ItemStack stack = GlobalVariableHelper.getStack(id, var);
            String val = PneumaticCraftUtils.posToString(pos) + (String)(stack.m_41619_() ? "" : " / " + PneumaticCraftUtils.getRegistryName(stack.m_41720_()).orElse(UNKNOWN_ITEM));
            source.m_288197_(() -> Component.m_237113_((String)var).m_130946_(" = [").m_130946_(val).m_130946_("]"), false);
        });
        return 1;
    }

    private static int getGlobalVar(CommandContext<CommandSourceStack> ctx, String varName0) {
        UUID uUID;
        Entity entity;
        Object varName;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!GlobalVariableHelper.hasPrefix(varName0)) {
            source.m_288197_(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName0).m_130940_(ChatFormatting.GOLD), false);
            varName = "#" + varName0;
        } else {
            varName = varName0;
        }
        if (((String)varName).startsWith("%") || !((entity = ((CommandSourceStack)ctx.getSource()).m_81373_()) instanceof Player)) {
            uUID = null;
        } else {
            Player player = (Player)entity;
            uUID = player.m_20148_();
        }
        UUID id = uUID;
        BlockPos pos = GlobalVariableHelper.getPos(id, (String)varName);
        ItemStack stack = GlobalVariableHelper.getStack(id, (String)varName);
        String val = PneumaticCraftUtils.posToString(pos) + (String)(stack.m_41619_() ? "" : " / " + PneumaticCraftUtils.getRegistryName(stack.m_41720_()).orElse(UNKNOWN_ITEM));
        if (pos == null && stack.m_41619_()) {
            source.m_81352_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.missing", varName));
        } else {
            source.m_288197_(() -> ModCommands.lambda$getGlobalVar$19((String)varName, val), false);
        }
        return 1;
    }

    private static int setGlobalVar(CommandContext<CommandSourceStack> ctx, String varName0, Either<BlockPos, ItemInput> posOrItem) {
        Object varName;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!GlobalVariableHelper.hasPrefix(varName0)) {
            source.m_288197_(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName0).m_130940_(ChatFormatting.GOLD), false);
            varName = "#" + varName0;
        } else {
            varName = varName0;
        }
        try {
            UUID id = ((String)varName).startsWith("%") ? null : ((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_();
            Object v = varName;
            posOrItem.ifLeft(arg_0 -> ModCommands.lambda$setGlobalVar$22(id, (String)v, source, arg_0)).ifRight(arg_0 -> ModCommands.lambda$setGlobalVar$24(id, (String)v, source, arg_0));
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"Player-globals require player context!"));
        }
        return 1;
    }

    private static int delGlobalVar(CommandContext<CommandSourceStack> ctx, String varName0) {
        Object varName;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!GlobalVariableHelper.hasPrefix(varName0)) {
            source.m_288197_(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName0).m_130940_(ChatFormatting.GOLD), false);
            varName = "#" + varName0;
        } else {
            varName = varName0;
        }
        try {
            UUID id;
            UUID uUID = id = ((String)varName).startsWith("%") ? null : ((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_();
            if (GlobalVariableHelper.getPos(id, (String)varName) == null && GlobalVariableHelper.getStack(id, (String)varName).m_41619_()) {
                source.m_81352_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.missing", varName));
            } else {
                GlobalVariableHelper.setPos(id, (String)varName, null);
                GlobalVariableHelper.setStack(id, (String)varName, ItemStack.f_41583_);
                if (id != null) {
                    PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(((CommandSourceStack)ctx.getSource()).m_81375_(), (String)varName);
                } else {
                    NetworkHandler.sendToAll(new PacketSetGlobalVariable((String)varName, (BlockPos)null));
                    NetworkHandler.sendToAll(new PacketSetGlobalVariable((String)varName, ItemStack.f_41583_));
                }
                source.m_288197_(() -> ModCommands.lambda$delGlobalVar$26((String)varName), true);
            }
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237113_((String)"Player-globals require player context!"));
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$delGlobalVar$26(String varName) {
        return PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.delete", varName);
    }

    private static /* synthetic */ void lambda$setGlobalVar$24(UUID id, String v, CommandSourceStack source, ItemInput item) {
        ItemStack stack = new ItemStack((ItemLike)item.m_120979_());
        GlobalVariableHelper.setStack(id, v, stack);
        source.m_288197_(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.output", v, PneumaticCraftUtils.getRegistryName(stack.m_41720_()).orElse(UNKNOWN_ITEM)), true);
    }

    private static /* synthetic */ void lambda$setGlobalVar$22(UUID id, String v, CommandSourceStack source, BlockPos pos) {
        GlobalVariableHelper.setPos(id, v, pos);
        source.m_288197_(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.output", v, PneumaticCraftUtils.posToString(pos)), true);
    }

    private static /* synthetic */ Component lambda$getGlobalVar$19(String varName, String val) {
        return PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.output", varName, val);
    }

    private static class VarnameType
    implements ArgumentType<String> {
        private VarnameType() {
        }

        public String parse(StringReader reader) {
            int start = reader.getCursor();
            if (reader.peek() == '#' || reader.peek() == '%') {
                reader.skip();
            }
            while (reader.canRead() && (StringUtils.isAlphanumeric((CharSequence)String.valueOf(reader.peek())) || reader.peek() == '_')) {
                reader.skip();
            }
            return reader.getString().substring(start, reader.getCursor());
        }
    }
}

