/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedBeehive
extends AdvancedBeehiveAbstract {
    private final Supplier<BlockEntityType<AdvancedBeehiveBlockEntity>> blockEntitySupplier;
    public static final EnumProperty<VerticalHive> EXPANDED = EnumProperty.m_61587_((String)"expanded", VerticalHive.class);

    public AdvancedBeehive(BlockBehaviour.Properties properties, Supplier<BlockEntityType<AdvancedBeehiveBlockEntity>> blockEntitySupplier) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.NORTH)).m_61124_(EXPANDED, (Comparable)((Object)VerticalHive.NONE))).m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)));
        this.blockEntitySupplier = blockEntitySupplier;
    }

    public Supplier<BlockEntityType<AdvancedBeehiveBlockEntity>> getBlockEntitySupplier() {
        return this.blockEntitySupplier;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AdvancedBeehiveBlockEntity(this, pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : AdvancedBeehive.m_152132_(blockEntityType, this.getBlockEntitySupplier().get(), AdvancedBeehiveBlockEntity::tick);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EXPANDED, BeehiveBlock.f_49564_, BeehiveBlock.f_49563_});
    }

    public void updateState(Level world, BlockPos pos, BlockState state, boolean isRemoved) {
        if (this instanceof DragonEggHive) {
            return;
        }
        Pair<Pair<BlockPos, Direction>, BlockState> pair = AdvancedBeehive.getAdjacentBox(world, pos, false);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos boxPos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(world, pos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(world, pos, state, directionProperty);
            }
            ((ExpansionBox)((BlockState)pair.getRight()).m_60734_()).updateStateWithDirection(world, boxPos, (BlockState)pair.getRight(), directionProperty, (Direction)state.m_61143_((Property)BeehiveBlock.f_49563_));
        } else if (!isRemoved) {
            this.updateStateWithDirection(world, pos, state, VerticalHive.NONE);
        }
    }

    public void updateStateWithDirection(Level world, BlockPos pos, BlockState state, VerticalHive directionProperty) {
        world.m_46597_(pos, (BlockState)state.m_61124_(EXPANDED, (Comparable)((Object)directionProperty)));
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AdvancedBeehiveBlockEntity) {
            int n = ((AdvancedBeehiveBlockEntity)te).MAX_BEES = world.m_8055_(pos).m_61143_(EXPANDED) != VerticalHive.NONE ? 5 : 3;
            if (directionProperty.equals((Object)VerticalHive.NONE)) {
                ((AdvancedBeehiveBlockEntity)te).getUpgradeHandler().ifPresent(handler -> {
                    for (int slot = 0; slot < handler.getSlots(); ++slot) {
                        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(slot));
                    }
                });
            }
        }
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentBox(Level world, BlockPos pos, boolean onlyFreeBoxes) {
        for (Direction direction : BlockStateProperties.f_61372_.m_6908_()) {
            BlockPos newPos = pos.m_121945_(direction);
            BlockState blockStateAtPos = world.m_8055_(newPos);
            if (!(blockStateAtPos.m_60734_() instanceof ExpansionBox)) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public static VerticalHive calculateExpandedDirection(Level world, BlockPos hivePos, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair = AdvancedBeehive.getAdjacentBox(world, hivePos, true);
        VerticalHive directionProperty = VerticalHive.NONE;
        if (!isRemoved && pair != null) {
            boolean isValidExpandedPos;
            BlockState hiveBlockState = world.m_8055_(hivePos);
            Direction hiveDirection = (Direction)hiveBlockState.m_61143_((Property)BeehiveBlock.f_49563_);
            Direction boxDirection = (Direction)((Pair)pair.getLeft()).getRight();
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos boxPos = (BlockPos)posAndDirection.getLeft();
            boolean bl = isValidExpandedPos = !boxPos.equals((Object)hivePos.m_121945_(hiveDirection));
            if (!isValidExpandedPos && hiveDirection == Direction.NORTH) {
                isValidExpandedPos = boxDirection == Direction.WEST || boxDirection == Direction.EAST || boxDirection == Direction.SOUTH;
            } else if (!isValidExpandedPos && hiveDirection == Direction.SOUTH) {
                isValidExpandedPos = boxDirection == Direction.WEST || boxDirection == Direction.EAST || boxDirection == Direction.NORTH;
            } else if (!isValidExpandedPos && hiveDirection == Direction.WEST) {
                isValidExpandedPos = boxDirection == Direction.SOUTH || boxDirection == Direction.NORTH || boxDirection == Direction.EAST;
            } else if (!isValidExpandedPos && hiveDirection == Direction.EAST) {
                boolean bl2 = isValidExpandedPos = boxDirection == Direction.SOUTH || boxDirection == Direction.NORTH || boxDirection == Direction.WEST;
            }
            if (isValidExpandedPos) {
                if (hivePos.m_123342_() - boxPos.m_123342_() > 0) {
                    directionProperty = VerticalHive.DOWN;
                } else if (hivePos.m_123342_() - boxPos.m_123342_() < 0) {
                    directionProperty = VerticalHive.UP;
                } else if (hivePos.m_123341_() < boxPos.m_123341_()) {
                    directionProperty = hiveDirection == Direction.WEST ? VerticalHive.BACK : (hiveDirection == Direction.NORTH ? VerticalHive.LEFT : VerticalHive.RIGHT);
                } else if (hivePos.m_123341_() > boxPos.m_123341_()) {
                    directionProperty = hiveDirection == Direction.EAST ? VerticalHive.BACK : (hiveDirection == Direction.SOUTH ? VerticalHive.LEFT : VerticalHive.RIGHT);
                } else if (hivePos.m_123343_() < boxPos.m_123343_()) {
                    directionProperty = hiveDirection == Direction.NORTH ? VerticalHive.BACK : (hiveDirection == Direction.EAST ? VerticalHive.LEFT : VerticalHive.RIGHT);
                } else if (hivePos.m_123343_() > boxPos.m_123343_()) {
                    directionProperty = hiveDirection == Direction.SOUTH ? VerticalHive.BACK : (hiveDirection == Direction.WEST ? VerticalHive.LEFT : VerticalHive.RIGHT);
                }
            }
        }
        return directionProperty;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.m_5776_()) {
            this.updateState(level, pos, state, false);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean removed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (!level.m_5776_()) {
            this.updateState(level, pos, state, true);
        }
        return removed;
    }

    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) instanceof AdvancedBeehiveBlockEntity) {
            tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
            ((AdvancedBeehiveBlockEntity)tileEntity).getUpgradeHandler().ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity;
        ItemStack heldItem = player.m_21120_(hand);
        int honeyLevel = (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_);
        boolean itemUsed = false;
        if (honeyLevel >= this.getMaxHoneyLevel()) {
            if (heldItem.m_41720_() == Items.f_42574_) {
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11697_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.m_49600_((Level)level, (BlockPos)pos);
                heldItem.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
                itemUsed = true;
            } else if (heldItem.m_41720_() == Items.f_42590_) {
                heldItem.m_41774_(1);
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42787_));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42787_))) {
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42787_), false);
                }
                itemUsed = true;
            }
        }
        if (itemUsed) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(this.getMaxHoneyLevel() - 5)));
        } else if (!level.m_5776_() && (tileEntity = level.m_7702_(pos)) instanceof AdvancedBeehiveBlockEntity) {
            level.m_7260_(pos, state, state, 3);
            this.openGui((ServerPlayer)player, (AdvancedBeehiveBlockEntity)tileEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public void openGui(ServerPlayer player, AdvancedBeehiveBlockEntity tileEntity) {
        this.updateState(tileEntity.m_58904_(), tileEntity.m_58899_(), tileEntity.m_58900_(), false);
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)tileEntity, packetBuffer -> packetBuffer.m_130064_(tileEntity.m_58899_()));
    }
}

