/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BeeFishingRecipeCategory
implements IRecipeCategory<BeeFishingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BeeFishingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_fishing_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 110);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42523_));
    }

    public RecipeType<BeeFishingRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.BEE_FISHING_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivebees.bee_fishing");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(BeeFishingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int xPos = 0;
        AtomicInteger yPos = new AtomicInteger(45);
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null) {
            Registry biomeRegistry = minecraft.f_91073_.m_9598_().m_175515_(Registries.f_256952_);
            for (Biome biome : BeeFishingRecipe.getBiomeList(recipe, (Level)minecraft.f_91073_)) {
                ResourceLocation key = biomeRegistry.m_7981_((Object)biome);
                if (key == null) continue;
                guiGraphics.m_280649_(minecraft.f_91062_, Language.m_128107_().m_5536_((FormattedText)Component.m_237115_((String)("biome.minecraft." + key.m_135815_()))), xPos, yPos.get(), -16777216, false);
                Objects.requireNonNull(minecraft.f_91062_);
                yPos.addAndGet(9 + 2);
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeeFishingRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.output.get()))).setSlotName("source");
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(Ingredient.m_204132_(ModTags.Forge.FISHING_RODS).m_43908_()));
    }
}

