/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivetrees.inventory.WoodWorkerContainer;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodWorkerBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    protected int tickCounter = 0;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    public static int SLOT_AXE = 2;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(3, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.isInputSlotItem(slot, stack);
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            return false;
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT};
        }

        protected void onContentsChanged(int slot) {
            Level level;
            super.onContentsChanged(slot);
            if (slot == SLOT_AXE && (level = WoodWorkerBlockEntity.this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7260_(WoodWorkerBlockEntity.this.m_58899_(), WoodWorkerBlockEntity.this.m_58900_(), WoodWorkerBlockEntity.this.m_58900_(), 2);
            }
        }
    });

    private boolean canProcess(ItemStack stack) {
        ItemStack stripped = TreeUtil.getStrippedItem(stack);
        return !stripped.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stripped);
    }

    public WoodWorkerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.WOOD_WORKER_BLOCK_ENTITY.get(), pos, state);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)((Block)TreeRegistrator.STRIPPER.get()).m_7705_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WoodWorkerBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % 10 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockEntity.inventoryHandler.ifPresent(inv -> {});
        }
    }

    public ItemStack getAxe() {
        return this.inventoryHandler.map(h -> h.getStackInSlot(SLOT_AXE)).orElse(ItemStack.f_41583_);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new WoodWorkerContainer(windowId, playerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

