/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33.batching;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.SectionPos;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.DrawBatchInternal;
import net.roguelogix.quartz.internal.IrisDetection;
import net.roguelogix.quartz.internal.MagicNumbers;
import net.roguelogix.quartz.internal.MultiBuffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.common.DynamicMatrixManager;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl33.GL33Buffer;
import net.roguelogix.quartz.internal.gl33.GL33FeedbackDrawing;
import net.roguelogix.quartz.internal.gl33.GL33LightEngine;
import net.roguelogix.quartz.internal.gl33.batching.GL33DrawChunk;
import net.roguelogix.quartz.internal.gl33.batching.GL33Instance;
import net.roguelogix.quartz.internal.gl33.batching.GL33InstanceBatch;
import net.roguelogix.quartz.internal.gl33.batching.GL33InstanceManager;
import org.joml.Matrix4fc;
import org.joml.Vector3ic;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL33C;

@NonnullDefault
public class GL33DrawBatch
implements DrawBatchInternal {
    private boolean enabled = true;
    private boolean culled = false;
    private boolean instanceAABBsDirty = false;
    @Nullable
    private AABB cullAABB = null;
    private Vector4f cullVector = new Vector4f();
    private Vector4f cullVectorMin = new Vector4f();
    private Vector4f cullVectorMax = new Vector4f();
    final GL33Buffer instanceDataBuffer = new GL33Buffer(false);
    final GL33Buffer intermediateInstanceDataBuffer = new GL33Buffer(true);
    final Reference2ReferenceMap<InternalMesh, GL33InstanceManager> instanceManagers = new Reference2ReferenceOpenHashMap();
    final ReferenceSet<GL33InstanceManager> instanceBatches = new ReferenceOpenHashSet();
    final FastArraySet<GL33InstanceManager> dirtyBatches = new FastArraySet();
    final MultiBuffer<GL33Buffer> dynamicMatrixBuffer = new MultiBuffer(1, false);
    final DynamicMatrixManager dynamicMatrixManager = new DynamicMatrixManager(this.dynamicMatrixBuffer);
    final int dynamicMatrixTexture;
    final DynamicMatrix IDENTITY_DYNAMIC_MATRIX = this.dynamicMatrixManager.createMatrix(null, null);
    private final Reference2ReferenceMap<RenderType, ReferenceArrayList<GL33DrawChunk>> renderChunkLists = new Reference2ReferenceArrayMap();
    private final ReferenceArrayList<RenderType> usedRenderTypes = new ReferenceArrayList();
    private boolean vertexCountDirty = false;
    private final Reference2IntMap<RenderType> verticesPerRenderType = new Reference2IntOpenHashMap();
    private final ReferenceArrayList<GL33LightEngine.ChunkHandle> cullLightChunks = new ReferenceArrayList();
    private final ReferenceArrayList<GL33LightEngine.ChunkHandle> instanceLightChunks = new ReferenceArrayList();

    public GL33DrawBatch() {
        ReferenceArrayList<RenderType> renderTypes = this.usedRenderTypes;
        int matrixTexture = GL33C.glGenTextures();
        GL33C.glBindTexture((int)35882, (int)matrixTexture);
        GL33C.glTexBuffer((int)35882, (int)34836, (int)this.dynamicMatrixBuffer.activeBuffer().handle());
        GL33C.glBindTexture((int)35882, (int)0);
        QuartzCore.mainThreadClean(this, () -> {
            GL33C.glDeleteTextures((int)matrixTexture);
            renderTypes.forEach(GL33FeedbackDrawing::removeRenderTypeUse);
        });
        this.dynamicMatrixTexture = matrixTexture;
    }

    @Override
    @Nullable
    public DrawBatch.Instance createInstance(Vector3ic position, Mesh mesh, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable AABB aabb) {
        DynamicMatrixManager.Matrix castedMatrix;
        InternalMesh castedMesh;
        block7: {
            block6: {
                if (!(mesh instanceof InternalMesh)) {
                    return null;
                }
                castedMesh = (InternalMesh)mesh;
                if (dynamicMatrix == null) {
                    dynamicMatrix = this.IDENTITY_DYNAMIC_MATRIX;
                }
                if (!(dynamicMatrix instanceof DynamicMatrixManager.Matrix)) break block6;
                castedMatrix = (DynamicMatrixManager.Matrix)dynamicMatrix;
                if (this.dynamicMatrixManager.owns(dynamicMatrix)) break block7;
            }
            return null;
        }
        if (staticMatrix == null) {
            staticMatrix = MagicNumbers.IDENTITY_MATRIX;
        }
        GL33InstanceManager instanceManager = (GL33InstanceManager)this.instanceManagers.computeIfAbsent((Object)castedMesh, internalMesh -> new GL33InstanceManager(this, (InternalMesh)internalMesh, true));
        return instanceManager.createInstance(position, castedMatrix, staticMatrix, aabb);
    }

    @Override
    @Nullable
    public DrawBatch.InstanceBatch createInstanceBatch(Mesh mesh) {
        if (!(mesh instanceof InternalMesh)) {
            return null;
        }
        InternalMesh castedMesh = (InternalMesh)mesh;
        return new GL33InstanceBatch(new GL33InstanceManager(this, castedMesh, false));
    }

    @Override
    public DynamicMatrix createDynamicMatrix(@Nullable Matrix4fc initialValue, @Nullable DynamicMatrix parentTransform, @Nullable DynamicMatrix.UpdateFunc updateFunc) {
        return this.dynamicMatrixManager.createMatrix(initialValue, updateFunc, parentTransform);
    }

    @Override
    public void setCullAABB(@Nullable AABB aabb) {
        if (aabb == null) {
            this.cullAABB = null;
            return;
        }
        this.cullAABB = aabb;
        this.cullLightChunks.clear();
        for (int X = this.cullAABB.minX(); X < (this.cullAABB.maxX() + 16 & 0xFFFFFFF0); X += 16) {
            for (int Y = this.cullAABB.minY(); Y < (this.cullAABB.maxY() + 16 & 0xFFFFFFF0); Y += 16) {
                for (int Z = this.cullAABB.minZ(); Z < (this.cullAABB.maxZ() + 16 & 0xFFFFFFF0); Z += 16) {
                    int chunkX = X >> 4;
                    int chunkY = Y >> 4;
                    int chunkZ = Z >> 4;
                    this.cullLightChunks.add((Object)GL33LightEngine.getChunk(SectionPos.m_123209_((int)chunkX, (int)chunkY, (int)chunkZ)));
                }
            }
        }
    }

    public void instanceAABBsDirty() {
        this.instanceAABBsDirty = true;
    }

    private void updateInstanceAABBs() {
        if (!this.instanceAABBsDirty) {
            return;
        }
        this.instanceAABBsDirty = false;
        AABB fullAABB = new AABB();
        for (GL33InstanceManager batch : this.instanceBatches) {
            for (WeakReference instanceRef : batch.instances) {
                GL33Instance instance = (GL33Instance)instanceRef.get();
                if (instance == null || instance.aabb == null) continue;
                fullAABB = fullAABB.union(instance.aabb);
            }
        }
        this.instanceLightChunks.clear();
        for (int X = fullAABB.minX(); X < (fullAABB.maxX() + 16 & 0xFFFFFFF0); X += 16) {
            for (int Y = fullAABB.minY(); Y < (fullAABB.maxY() + 16 & 0xFFFFFFF0); Y += 16) {
                for (int Z = fullAABB.minZ(); Z < (fullAABB.maxZ() + 16 & 0xFFFFFFF0); Z += 16) {
                    int chunkX = X >> 4;
                    int chunkY = Y >> 4;
                    int chunkZ = Z >> 4;
                    this.instanceLightChunks.add((Object)GL33LightEngine.getChunk(SectionPos.m_123209_((int)chunkX, (int)chunkY, (int)chunkZ)));
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEmpty() {
        return this.instanceManagers.isEmpty() && this.instanceBatches.isEmpty();
    }

    void setVertexCountDirty() {
        this.vertexCountDirty = true;
    }

    void addDrawChunk(GL33DrawChunk chunk) {
        ReferenceArrayList components = (ReferenceArrayList)this.renderChunkLists.computeIfAbsent((Object)chunk.renderType, e -> new ReferenceArrayList());
        chunk.drawIndex = components.size();
        components.add((Object)chunk);
    }

    void removeDrawChunk(GL33DrawChunk chunk) {
        if (chunk.drawIndex == -1) {
            return;
        }
        ReferenceArrayList components = (ReferenceArrayList)this.renderChunkLists.get((Object)chunk.renderType);
        if (components == null) {
            return;
        }
        GL33DrawChunk lastChunk = (GL33DrawChunk)components.pop();
        if (lastChunk == chunk) {
            chunk.drawIndex = -1;
            return;
        }
        lastChunk.drawIndex = chunk.drawIndex;
        chunk.drawIndex = -1;
        components.set(lastChunk.drawIndex, (Object)lastChunk);
    }

    public int verticesForRenderType(RenderType renderType, boolean shadowsEnabled) {
        if (!this.enabled) {
            return 0;
        }
        if (this.culled && !shadowsEnabled) {
            return 0;
        }
        if (this.isEmpty()) {
            return 0;
        }
        int vertices = this.verticesPerRenderType.getOrDefault((Object)renderType, -1);
        if (vertices == -1) {
            return 0;
        }
        return vertices;
    }

    @Override
    public void updateAndCull(DrawInfo drawInfo) {
        int i;
        this.dynamicMatrixManager.updateAll(drawInfo.deltaNano, drawInfo.partialTicks, drawInfo.playerPosition, drawInfo.playerSubBlock);
        this.dynamicMatrixBuffer.activeBuffer().flush();
        if (!this.dirtyBatches.isEmpty()) {
            for (i = 0; i < this.dirtyBatches.size(); ++i) {
                GL33InstanceManager batch = (GL33InstanceManager)this.dirtyBatches.get(i);
                batch.writeUpdates();
            }
            this.dirtyBatches.clear();
            this.instanceDataBuffer.flush();
        }
        if (!this.enabled) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.cullAABB != null && !IrisDetection.areShadersActive()) {
            this.cullVectorMin.set(2.0f);
            this.cullVectorMax.set(-2.0f);
            for (i = 0; i < 8; ++i) {
                this.cullVector.set((float)(((i & 1) == 0 ? this.cullAABB.maxX() : this.cullAABB.minX()) - drawInfo.playerPosition.x), (float)(((i & 2) == 0 ? this.cullAABB.maxY() : this.cullAABB.minY()) - drawInfo.playerPosition.y), (float)(((i & 4) == 0 ? this.cullAABB.maxZ() : this.cullAABB.minZ()) - drawInfo.playerPosition.z), 1.0f);
                this.cullVector.sub(drawInfo.playerSubBlock.x, drawInfo.playerSubBlock.y, drawInfo.playerSubBlock.z, 0.0f);
                this.cullVector.mul((Matrix4fc)drawInfo.projectionMatrix);
                this.cullVector.div(this.cullVector.w);
                this.cullVectorMin.min((Vector4fc)this.cullVector);
                this.cullVectorMax.max((Vector4fc)this.cullVector);
            }
            this.culled = this.cullVectorMin.x > 1.0f || this.cullVectorMax.x < -1.0f || this.cullVectorMin.y > 1.0f || this.cullVectorMax.y < -1.0f || this.cullVectorMin.z > 1.0f || this.cullVectorMax.z < -1.0f;
        } else {
            this.culled = false;
        }
        if (this.culled) {
            return;
        }
        if (this.vertexCountDirty) {
            this.vertexCountDirty = false;
            for (Map.Entry value : this.renderChunkLists.entrySet()) {
                int totalVertices = 0;
                for (GL33DrawChunk chunk : (ReferenceArrayList)value.getValue()) {
                    totalVertices += chunk.vertexCount * chunk.manager.instanceCount();
                }
                this.verticesPerRenderType.put((Object)((RenderType)value.getKey()), totalVertices);
            }
            this.renderChunkLists.keySet().forEach(GL33FeedbackDrawing::addRenderTypeUse);
            this.usedRenderTypes.forEach(GL33FeedbackDrawing::removeRenderTypeUse);
            this.usedRenderTypes.clear();
            this.usedRenderTypes.addAll((Collection)this.renderChunkLists.keySet());
        }
        this.intermediateInstanceDataBuffer.expand(this.instanceDataBuffer.size());
        GL33C.glBindTexture((int)35882, (int)this.dynamicMatrixTexture);
        for (GL33InstanceManager batch : this.instanceManagers.values()) {
            GL33C.glBindBufferRange((int)35982, (int)0, (int)this.intermediateInstanceDataBuffer.handle(), (long)batch.instanceDataAlloc.offset(), (long)batch.instanceDataAlloc.size());
            GL33C.glBeginTransformFeedback((int)0);
            B3DStateHelper.bindVertexArray(batch.matrixUpdateVAO);
            GL33C.glDrawArrays((int)0, (int)0, (int)batch.instanceCount());
            GL33C.glEndTransformFeedback();
        }
        for (GL33InstanceManager batch : this.instanceBatches) {
            GL33C.glBindBufferRange((int)35982, (int)0, (int)this.intermediateInstanceDataBuffer.handle(), (long)batch.instanceDataAlloc.offset(), (long)batch.instanceDataAlloc.size());
            GL33C.glBeginTransformFeedback((int)0);
            B3DStateHelper.bindVertexArray(batch.matrixUpdateVAO);
            GL33C.glDrawArrays((int)0, (int)0, (int)batch.instanceCount());
            GL33C.glEndTransformFeedback();
        }
    }

    @Override
    public void drawFeedback(RenderType renderType, boolean shadowsEnabled) {
        if (!this.enabled) {
            return;
        }
        if (this.culled && !shadowsEnabled) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        ReferenceArrayList chunks = (ReferenceArrayList)this.renderChunkLists.get((Object)renderType);
        if (chunks == null) {
            return;
        }
        for (GL33DrawChunk chunk : chunks) {
            chunk.draw();
        }
    }

    public void rebuildVAOs() {
        for (GL33InstanceManager batch : this.instanceManagers.values()) {
            for (GL33DrawChunk chunk : batch.drawChunks) {
                chunk.rebuildVAO(batch.instanceDataAlloc.offset());
            }
        }
        for (GL33InstanceManager batch : this.instanceBatches) {
            for (GL33DrawChunk chunk : batch.drawChunks) {
                chunk.rebuildVAO(batch.instanceDataAlloc.offset());
            }
        }
    }
}

