/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46;

import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.util.Util;
import org.lwjgl.opengl.GL45C;

public class GL46ComputePrograms {
    private static int dynamicMatrixProgram;
    private static int lightChunkProgram;

    private static int createProgram(String path) {
        int program = GL45C.glCreateShaderProgramv((int)37305, (CharSequence)Util.readResourceLocation((ResourceLocation)new ResourceLocation("quartz", path)));
        if (GL45C.glGetProgrami((int)program, (int)35714) != 1) {
            String infoLog = GL45C.glGetProgramInfoLog((int)program);
            GL45C.glDeleteProgram((int)program);
            throw new IllegalStateException("Compute program link failed for " + program + "\n" + infoLog + "\n");
        }
        return program;
    }

    public static void startup() {
        dynamicMatrixProgram = GL46ComputePrograms.createProgram("shaders/gl46/dynamic_matrix.comp");
        lightChunkProgram = GL46ComputePrograms.createProgram("shaders/gl46/light_chunks.comp");
    }

    public static void shutdown() {
        GL45C.glDeleteProgram((int)dynamicMatrixProgram);
        dynamicMatrixProgram = 0;
        GL45C.glDeleteProgram((int)lightChunkProgram);
        lightChunkProgram = 0;
    }

    public static void reload() {
        GL46ComputePrograms.shutdown();
        GL46ComputePrograms.startup();
    }

    public static int dynamicMatrixProgram() {
        return dynamicMatrixProgram;
    }

    public static int lightChunkProgram() {
        return lightChunkProgram;
    }
}

