/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.IntBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.VectorUtil;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.gl46.GL46Buffer;
import net.roguelogix.quartz.internal.gl46.GL46ComputePrograms;
import net.roguelogix.quartz.internal.gl46.GL46Statics;
import net.roguelogix.quartz.internal.gl46.SparseTextureHelper;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryStack;

public class GL46LightEngine {
    private static final int CHUNK_UPDATES_PER_FRAME = 16;
    private static boolean allocsDirty = false;
    private static final Long2ReferenceOpenHashMap<SoftReference<Chunk>> allChunks = new Long2ReferenceOpenHashMap();
    private static final Long2ReferenceOpenHashMap<WeakReference<ChunkHandle>> chunkHandles = new Long2ReferenceOpenHashMap();
    private static final FastArraySet<WeakReference<ChunkHandle>> dirtyChunks = new FastArraySet();
    private static int freeCommitedIndices = 0;
    private static final ObjectArrayList<ShortArrayList> freeIndices = new ObjectArrayList(GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.z());
    private static final BooleanArrayList residentLayers;
    private static final int[] intermediateTextures;
    private static int intermediateTextureDepth;
    private static final Vector3i virtualPageSize;
    private static final GL46Buffer rawDataBuffer;
    private static PointerWrapper lookupData;
    private static Vector3i lookupOffset;
    private static GL46Buffer lookupBuffer;
    private static int lookupTexture;
    private static GL46Buffer unpackBuffer;
    private static GL46Buffer.Allocation[] unpackBufferAllocs;
    private static long lastLightUpdateFence;

    public static void startup() {
        int i;
        int pageSizeIndex = -1;
        if (GL46Statics.SPARSE_TEXTURE_ENABLED) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                int format = 36209;
                int pageSizeCount = GL45C.glGetInternalformati((int)35866, (int)36209, (int)37288);
                if (pageSizeCount == 0) {
                    throw new IllegalStateException("No sparse page sizes for GL_R16UI");
                }
                IntBuffer sizesX = stack.mallocInt(pageSizeCount);
                IntBuffer sizesY = stack.mallocInt(pageSizeCount);
                IntBuffer sizesZ = stack.mallocInt(pageSizeCount);
                GL45C.glGetInternalformativ((int)35866, (int)36209, (int)37269, (IntBuffer)sizesX);
                GL45C.glGetInternalformativ((int)35866, (int)36209, (int)37270, (IntBuffer)sizesY);
                GL45C.glGetInternalformativ((int)35866, (int)36209, (int)37271, (IntBuffer)sizesZ);
                for (int i2 = 0; i2 < pageSizeCount; ++i2) {
                    int xSize = sizesX.get(i2);
                    int ySize = sizesY.get(i2);
                    int zSize = sizesZ.get(i2);
                    if (GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.x() % xSize != 0 || GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.y() % ySize != 0 || 1 % zSize != 0) continue;
                    virtualPageSize.set(xSize, ySize, zSize);
                    pageSizeIndex = i2;
                    break;
                }
                if (pageSizeIndex == -1) {
                    throw new IllegalStateException("No viable page size for GL_R16UI");
                }
            }
        }
        GL45C.glCreateTextures((int)35866, (int[])intermediateTextures);
        for (i = 0; i < intermediateTextures.length; ++i) {
            int texture = intermediateTextures[i];
            if (GL46Statics.SPARSE_TEXTURE_ENABLED) {
                GL45C.glTextureParameteri((int)texture, (int)37286, (int)1);
                GL45C.glTextureParameteri((int)texture, (int)37287, (int)pageSizeIndex);
            }
            GL45C.glTextureParameteri((int)texture, (int)10241, (int)9728);
            GL45C.glTextureParameteri((int)texture, (int)10240, (int)9728);
            GL45C.glTextureStorage3D((int)texture, (int)1, (int)33332, (int)GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.x(), (int)GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.y(), (int)32);
        }
        for (i = GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.z() - 1; i >= 0; --i) {
            residentLayers.add(false);
        }
        lookupTexture = GL45C.glCreateTextures((int)35882);
        GL45C.glTextureBuffer((int)lookupTexture, (int)33332, (int)lookupBuffer.handle());
        for (i = 0; i < 16; ++i) {
            GL46LightEngine.unpackBufferAllocs[i] = unpackBuffer.alloc(522240, 2);
        }
    }

    public static void shutdown() {
        GL45C.glDeleteTextures((int[])intermediateTextures);
        rawDataBuffer.delete();
        lookupData.free();
    }

    public static Vector3ic lookupOffset() {
        return lookupOffset;
    }

    public static void bind() {
        GL45C.glActiveTexture((int)33985);
        GL45C.glBindTexture((int)35882, (int)lookupTexture);
        for (int i = 0; i < 6; ++i) {
            GL45C.glActiveTexture((int)(33986 + i));
            GL45C.glBindTexture((int)35866, (int)intermediateTextures[i]);
        }
        GL45C.glActiveTexture((int)33984);
    }

    public static void unbind() {
        GL45C.glActiveTexture((int)33985);
        GL45C.glBindTexture((int)35882, (int)0);
        for (int i = 0; i < 6; ++i) {
            GL45C.glActiveTexture((int)(33986 + i));
            GL45C.glBindTexture((int)35866, (int)0);
        }
        GL45C.glActiveTexture((int)33984);
    }

    private static short allocLightChunk() {
        ShortArrayList indices;
        allocsDirty = true;
        for (int i = 0; i < residentLayers.size(); ++i) {
            if (!residentLayers.getBoolean(i) || (indices = (ShortArrayList)freeIndices.get(i)).isEmpty()) continue;
            short index = indices.popShort();
            --freeCommitedIndices;
            index = (short)(index << 10);
            index = (short)(index | i);
            return index;
        }
        for (int layerIndex = 0; layerIndex < residentLayers.size(); ++layerIndex) {
            if (residentLayers.getBoolean(layerIndex)) continue;
            indices = (ShortArrayList)freeIndices.get(layerIndex);
            indices.clear();
            for (short j = 59; j >= 0; j = (short)(j - 1)) {
                indices.add(j);
            }
            if (GL46Statics.SPARSE_TEXTURE_ENABLED) {
                for (int i = 0; i < intermediateTextures.length; ++i) {
                    SparseTextureHelper.glTexturePageCommitmentEXT(intermediateTextures[i], 0, 0, 0, layerIndex, GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.x(), GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.y(), 1, true);
                }
            } else if (layerIndex >= intermediateTextureDepth) {
                int i;
                int newTextureDepth = intermediateTextureDepth + 32;
                int[] newTextures = new int[6];
                GL45C.glCreateTextures((int)35866, (int[])newTextures);
                for (i = 0; i < newTextures.length; ++i) {
                    int texture = newTextures[i];
                    GL45C.glTextureParameteri((int)texture, (int)10241, (int)9728);
                    GL45C.glTextureParameteri((int)texture, (int)10240, (int)9728);
                    GL45C.glTextureStorage3D((int)texture, (int)1, (int)33332, (int)GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.x(), (int)GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.y(), (int)newTextureDepth);
                    GL45C.glCopyImageSubData((int)intermediateTextures[i], (int)35866, (int)0, (int)0, (int)0, (int)0, (int)newTextures[i], (int)35866, (int)0, (int)0, (int)0, (int)0, (int)GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.x(), (int)GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.y(), (int)intermediateTextureDepth);
                }
                GL45C.glDeleteTextures((int[])intermediateTextures);
                for (i = 0; i < intermediateTextures.length; ++i) {
                    GL46LightEngine.intermediateTextures[i] = newTextures[i];
                }
                intermediateTextureDepth = newTextureDepth;
            }
            freeCommitedIndices += 60;
            residentLayers.set(layerIndex, true);
            short index = indices.popShort();
            --freeCommitedIndices;
            index = (short)(index << 10);
            index = (short)(index | layerIndex);
            return index;
        }
        throw new IllegalStateException("Unable to allocate lighting chunk index");
    }

    private static void freeLightChunk(short index) {
        allocsDirty = true;
        int layerIndex = index & 0x3FF;
        short subIndex = (short)(index >> 10 & 0x3F);
        if (!residentLayers.getBoolean(layerIndex)) {
            throw new IllegalArgumentException("Attempt to free lighting chunk index from non-resident layer");
        }
        ShortArrayList indices = (ShortArrayList)freeIndices.get(layerIndex);
        indices.add(subIndex);
        if (freeIndices.size() != 60) {
            return;
        }
        if (freeCommitedIndices <= 120) {
            return;
        }
        if (GL46Statics.SPARSE_TEXTURE_ENABLED) {
            for (int i = 0; i < intermediateTextures.length; ++i) {
                SparseTextureHelper.glTexturePageCommitmentEXT(intermediateTextures[i], 0, 0, 0, layerIndex, GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.x(), GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.y(), 1, false);
            }
        }
        freeCommitedIndices -= 60;
        residentLayers.set(layerIndex, false);
    }

    public static void update(BlockAndTintGetter blockAndTintGetter) {
        GL46LightEngine.runLightingUpdates(blockAndTintGetter);
        GL46LightEngine.runAllocUpdates();
    }

    public static void runLightingUpdates(BlockAndTintGetter blockAndTintGetter) {
        int i;
        if (dirtyChunks.isEmpty()) {
            return;
        }
        if (lastLightUpdateFence != 0L) {
            GL45C.glWaitSync((long)lastLightUpdateFence, (int)0, (long)-1L);
            GL45C.glDeleteSync((long)lastLightUpdateFence);
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            GL45C.glBindImageTexture((int)(i2 + 1), (int)intermediateTextures[i2], (int)0, (boolean)true, (int)0, (int)35001, (int)33332);
        }
        int updatesThisFrame = 0;
        for (i = 0; i < dirtyChunks.size(); ++i) {
            WeakReference value = (WeakReference)dirtyChunks.get(i);
            ChunkHandle chunk = (ChunkHandle)value.get();
            if (chunk == null) {
                dirtyChunks.remove((Object)value);
                --i;
                continue;
            }
            if (chunk.chunk.update(blockAndTintGetter, unpackBufferAllocs[updatesThisFrame])) {
                ++updatesThisFrame;
            }
            if (!chunk.chunk.dirty) {
                dirtyChunks.remove((Object)value);
                --i;
            }
            if (updatesThisFrame >= 16) break;
        }
        GL45C.glMemoryBarrier((int)8192);
        GL45C.glBindBuffer((int)35052, (int)0);
        for (i = 0; i < 6; ++i) {
            GL45C.glBindImageTexture((int)(i + 1), (int)0, (int)0, (boolean)true, (int)0, (int)35001, (int)33332);
        }
        lastLightUpdateFence = GL45C.glFenceSync((int)37143, (int)0);
    }

    public static void runAllocUpdates() {
        long chunkPos;
        if (!allocsDirty) {
            return;
        }
        allocsDirty = false;
        Vector3i tempVec = new Vector3i();
        lookupOffset.set(Integer.MAX_VALUE);
        for (Long2ReferenceMap.Entry chunk : chunkHandles.long2ReferenceEntrySet()) {
            chunkPos = chunk.getLongKey();
            lookupOffset.min((Vector3ic)VectorUtil.fromSectionPos((long)chunkPos, (Vector3i)tempVec));
        }
        lookupData.set((byte)-1);
        for (Long2ReferenceMap.Entry chunkEntry : chunkHandles.long2ReferenceEntrySet()) {
            chunkPos = chunkEntry.getLongKey();
            ChunkHandle chunkHandle = (ChunkHandle)((WeakReference)chunkEntry.getValue()).get();
            if (chunkHandle == null) continue;
            short lookupIndex = chunkHandle.chunk.lightChunkIndex;
            VectorUtil.fromSectionPos((long)chunkPos, (Vector3i)tempVec);
            tempVec.sub((Vector3ic)lookupOffset);
            int texelIndex = 0;
            texelIndex += tempVec.z;
            texelIndex *= 24;
            texelIndex += tempVec.y;
            texelIndex *= 64;
            lookupData.putShortIdx(texelIndex += tempVec.x, lookupIndex);
        }
        GL45C.nglNamedBufferSubData((int)lookupBuffer.handle(), (long)0L, (long)lookupData.size(), (long)lookupData.pointer());
    }

    public static void sectionDirty(int x, int y, int z) {
        long pos = SectionPos.m_123209_((int)x, (int)y, (int)z);
        WeakReference weakRef = (WeakReference)chunkHandles.get(pos);
        if (weakRef == null) {
            return;
        }
        ChunkHandle chunk = (ChunkHandle)weakRef.get();
        if (chunk == null) {
            return;
        }
        chunk.chunk.dirty = true;
        dirtyChunks.add((Object)weakRef);
    }

    public static ChunkHandle getChunk(long position) {
        ChunkHandle existingHandle;
        WeakReference existingHandleRef = (WeakReference)chunkHandles.get(position);
        if (existingHandleRef != null && (existingHandle = (ChunkHandle)existingHandleRef.get()) != null) {
            return existingHandle;
        }
        Chunk chunk = GL46LightEngine.getActualChunk(position);
        ChunkHandle handle = new ChunkHandle(chunk);
        WeakReference<ChunkHandle> reference = new WeakReference<ChunkHandle>(handle);
        allocsDirty = true;
        chunkHandles.put(position, reference);
        chunk.dirty = true;
        dirtyChunks.add(reference);
        return handle;
    }

    private static Chunk getActualChunk(long pos) {
        Chunk chunk;
        SoftReference softRef = (SoftReference)allChunks.get(pos);
        if (softRef != null && (chunk = (Chunk)softRef.get()) != null) {
            return chunk;
        }
        Chunk newChunk = new Chunk(pos);
        allChunks.put(pos, new SoftReference<Chunk>(newChunk));
        return newChunk;
    }

    static {
        for (int i = 0; i < GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.z(); ++i) {
            freeIndices.add((Object)new ShortArrayList(60));
        }
        residentLayers = new BooleanArrayList(GL46Statics.LIGHT_SPARE_TEXTURE_SIZE.z());
        intermediateTextures = new int[6];
        intermediateTextureDepth = 32;
        virtualPageSize = new Vector3i();
        rawDataBuffer = new GL46Buffer(false);
        lookupData = PointerWrapper.alloc(196608L);
        lookupOffset = new Vector3i();
        lookupBuffer = new GL46Buffer(196608, true);
        unpackBuffer = new GL46Buffer(2088960, true);
        unpackBufferAllocs = new GL46Buffer.Allocation[16];
        lastLightUpdateFence = 0L;
    }

    public static final class ChunkHandle {
        private final Chunk chunk;

        private ChunkHandle(Chunk chunk) {
            this.chunk = chunk;
            long pos = chunk.sectionPos;
            QuartzCore.mainThreadClean(this, () -> {
                allocsDirty = true;
                WeakReference removedRef = (WeakReference)chunkHandles.remove(pos);
                if (removedRef.get() != null) {
                    chunkHandles.put(pos, (Object)removedRef);
                }
            });
        }
    }

    private static class Chunk {
        public final long sectionPos;
        public final short lightChunkIndex;
        private final GL46Buffer.Allocation alloc;
        private final long[] lastSync;
        private boolean dirty = false;

        private Chunk(long pos) {
            this.sectionPos = pos;
            short lightChunkIndex = GL46LightEngine.allocLightChunk();
            this.dirty = true;
            GL46Buffer.Allocation alloc = rawDataBuffer.alloc(12288, 12288);
            long[] lastSync = new long[1];
            QuartzCore.mainThreadClean(this, () -> {
                if (lastSync[0] != 0L) {
                    GL45C.glClientWaitSync((long)lastSync[0], (int)1, (long)0L);
                    GL45C.glDeleteSync((long)lastSync[0]);
                }
                alloc.free();
                GL46LightEngine.freeLightChunk(lightChunkIndex);
            });
            this.lightChunkIndex = lightChunkIndex;
            this.alloc = alloc;
            this.lastSync = lastSync;
        }

        private boolean update(BlockAndTintGetter blockAndTintGetter, GL46Buffer.Allocation unpackAllocation) {
            if (!this.dirty) {
                return false;
            }
            this.dirty = false;
            if (this.lastSync[0] != 0L) {
                int waitResult = GL45C.glClientWaitSync((long)this.lastSync[0], (int)1, (long)0L);
                if (waitResult == 37149) {
                    throw new IllegalStateException("OpenGL wait failed");
                }
                if (waitResult == 37147) {
                    return false;
                }
                GL45C.glDeleteSync((long)this.lastSync[0]);
                this.lastSync[0] = 0L;
            }
            int sectionBaseX = SectionPos.m_123223_((int)SectionPos.m_123213_((long)this.sectionPos));
            int sectionBaseY = SectionPos.m_123223_((int)SectionPos.m_123225_((long)this.sectionPos));
            int sectionBaseZ = SectionPos.m_123223_((int)SectionPos.m_123230_((long)this.sectionPos));
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            PointerWrapper pointer = this.alloc.address();
            int index = 0;
            for (int x = -1; x < 17; ++x) {
                for (int y = -1; y < 17; ++y) {
                    for (int z = -1; z < 17; ++z) {
                        int skyLight;
                        int blockLight;
                        int currentX = sectionBaseX + x;
                        int currentY = sectionBaseY + y;
                        int currentZ = sectionBaseZ + z;
                        mutableBlockPos.m_122178_(currentX, currentY, currentZ);
                        BlockState blockState = blockAndTintGetter.m_8055_((BlockPos)mutableBlockPos);
                        if (!blockState.m_60631_((BlockGetter)blockAndTintGetter, (BlockPos)mutableBlockPos)) {
                            blockLight = -1;
                            skyLight = -1;
                        } else {
                            blockLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, (BlockPos)mutableBlockPos);
                            skyLight = blockAndTintGetter.m_45517_(LightLayer.SKY, (BlockPos)mutableBlockPos);
                        }
                        pointer.putByte(index++, (byte)skyLight);
                        pointer.putByte(index++, (byte)blockLight);
                    }
                }
            }
            GL45C.glBindBufferRange((int)37074, (int)0, (int)this.alloc.allocator().handle(), (long)this.alloc.offset(), (long)this.alloc.size());
            GL45C.glBindBufferRange((int)37074, (int)1, (int)unpackAllocation.allocator().handle(), (long)unpackAllocation.offset(), (long)unpackAllocation.size());
            int lightChunkX = this.lightChunkIndex >> 11 & 0x1F;
            int lightChunkY = this.lightChunkIndex >> 10 & 1;
            int lightChunkZ = this.lightChunkIndex & 0x3FF;
            GL45C.glProgramUniform3ui((int)GL46ComputePrograms.lightChunkProgram(), (int)0, (int)(lightChunkX * 17), (int)(lightChunkY * 320), (int)lightChunkZ);
            GL45C.glUseProgram((int)GL46ComputePrograms.lightChunkProgram());
            GL45C.glDispatchCompute((int)17, (int)17, (int)17);
            GL45C.glMemoryBarrier((int)128);
            GL45C.glBindBuffer((int)35052, (int)unpackAllocation.allocator().handle());
            for (int i = 0; i < intermediateTextures.length; ++i) {
                int lightChunkDirectionIndices = 21760;
                int offset = unpackAllocation.offset() + 21760 * i;
                GL45C.glTextureSubImage3D((int)intermediateTextures[i], (int)0, (int)(lightChunkX * 17), (int)(lightChunkY * 320), (int)lightChunkZ, (int)17, (int)320, (int)1, (int)36244, (int)5125, (long)offset);
            }
            this.lastSync[0] = GL45C.glFenceSync((int)37143, (int)0);
            return true;
        }
    }
}

