/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.vk;

import net.roguelogix.phosphophyllite.config.ConfigValue;

public class VKConfig {
    public static final VKConfig INSTANCE = new VKConfig();
    @ConfigValue
    public final boolean enable;
    @ConfigValue(comment="Debug and development options\nMay hurt performance\nShould not be used unless necessary or otherwise directed\nEnabling some of these may cause vulkan initialization to fail, potentially not being logged\n")
    public final DebugOptions debug = new DebugOptions();
    @ConfigValue(comment="Number of framebuffers to allocate\nAllows for the CPU/GPU to be working on multiple frames at the same time\nIncreasing this number increases host and device memory requirements for values that are updated every frame\n", range="[1,9]")
    public final int inFlightFrames;
    @ConfigValue(comment="Allows the use of a secondary thread for submission to the main graphics queue between frames\n")
    public final boolean secondaryGraphicsQueueThread;
    @ConfigValue
    public final boolean useHostFrameCopy;
    @ConfigValue
    public final MemoryOptions memory = new MemoryOptions();

    public VKConfig() {
        this.enable = false;
        this.inFlightFrames = 3;
        this.secondaryGraphicsQueueThread = true;
        this.useHostFrameCopy = false;
    }

    public static class DebugOptions {
        @ConfigValue(comment="Enables Vulkan validation layers")
        public final boolean enableValidationLayers;
        @ConfigValue(comment="Enabled RobustBufferAccess VkPhysicalDeviceFeature")
        public final boolean robustBufferAccess;
        @ConfigValue(comment="Allows wireframe rendering to be enabled")
        public final boolean allowWireFrame;

        public DebugOptions() {
            this.enableValidationLayers = false;
            this.robustBufferAccess = false;
            this.allowWireFrame = false;
        }
    }

    public static class MemoryOptions {
        @ConfigValue
        public final AllocationStyle deviceMemorySubAllocationStyle = AllocationStyle.BUDDY;
        @ConfigValue
        public final AllocationStyle bufferSubAllocationStyle = AllocationStyle.PACKED;
        @ConfigValue(comment="Size of VK memory allocations for both the host and device\ndefault is 128MiB\nlarger sizes may help with overall memory usage")
        public final int memoryBlockSize;
        @ConfigValue(comment="Minimum size allocated to a buffer, also serves serves as the minimum guaranteed alignment, will be rounded up to next power of two", range="[16384,)")
        public final int minimumBufferSize;

        public MemoryOptions() {
            this.memoryBlockSize = 0x10000000;
            this.minimumBufferSize = 65536;
        }

        public static enum AllocationStyle {
            BUDDY,
            PACKED;

        }
    }
}

