/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.entity;

import cofh.core.util.helpers.ArcheryHelper;
import cofh.redstonearsenal.common.item.IFluxItem;
import cofh.redstonearsenal.init.registries.ModEntities;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class FluxSlash
extends Projectile {
    public static float defaultSpeed = 2.0f;
    public float damage = 2.0f;
    public int duration = 5;
    public final float zRot;

    public FluxSlash(EntityType<? extends Projectile> type, Level worldIn) {
        super(type, worldIn);
        this.zRot = (worldIn.m_213780_().m_188501_() - 0.5f) * 50.0f;
    }

    public FluxSlash(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntities.FLUX_SLASH.get()), worldIn);
        this.m_6034_(x, y, z);
    }

    public FluxSlash(Level worldIn, LivingEntity livingEntityIn) {
        this(worldIn, livingEntityIn.m_20185_(), 0.7 * livingEntityIn.m_20188_() + 0.3 * livingEntityIn.m_20186_(), livingEntityIn.m_20189_());
        this.m_5602_((Entity)livingEntityIn);
        this.m_37251_((Entity)livingEntityIn, livingEntityIn.f_19858_, livingEntityIn.f_19857_, 0.0f, defaultSpeed, 0.5f);
    }

    public FluxSlash(Level worldIn, LivingEntity livingEntityIn, int damageModifier) {
        this(worldIn, livingEntityIn);
        this.damage += (float)damageModifier;
    }

    public FluxSlash(Level worldIn, LivingEntity livingEntityIn, int damageModifier, int durationModifier) {
        this(worldIn, livingEntityIn, damageModifier);
        this.duration += durationModifier;
    }

    protected void m_8097_() {
    }

    protected void m_5841_() {
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(IFluxItem.fluxRangedDamage(this, this.m_19749_()), this.damage);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > this.duration) {
            this.m_146870_();
        }
        this.calculateCollision(this.f_19853_);
        this.m_20101_();
        Vec3 velocity = this.m_20184_();
        this.m_6034_(this.m_20185_() + velocity.f_82479_, this.m_20186_() + velocity.f_82480_, this.m_20189_() + velocity.f_82481_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double p_70112_1_) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 = d0 * 64.0 * FluxSlash.m_20150_()) * d0;
    }

    protected void calculateCollision(Level world) {
        Vec3 start = this.m_20182_();
        Vec3 end = start.m_82549_(this.m_20184_());
        BlockHitResult blockResult = this.getBlockHitResult(world, start, end);
        boolean blockCollision = false;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            end = blockResult.m_82450_();
            blockCollision = true;
        }
        this.hitEntities(this.f_19853_, start, end);
        if (blockCollision && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)blockResult)) {
            this.m_8060_(blockResult);
        }
    }

    protected BlockHitResult getBlockHitResult(Level world, Vec3 startPos, Vec3 endPos) {
        return world.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    protected void hitEntities(Level world, Vec3 startPos, Vec3 endPos) {
        ArcheryHelper.findHitEntities((Level)world, (Projectile)this, (Vec3)startPos, (Vec3)endPos, x$0 -> this.m_5603_((Entity)x$0)).filter(result -> !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)).forEach(this::m_5790_);
    }
}

