/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.network;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketSyncVehicleInformationToClient(BlockPos pos, List<String> platforms, String currentPlatform, Boolean valid, Boolean enoughPower) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsbuilder", "sync_vehicle_information_to_client");

    public static PacketSyncVehicleInformationToClient create(BlockPos pos, List<String> platforms, String currentPlatform, boolean valid, boolean enoughPower) {
        return new PacketSyncVehicleInformationToClient(pos, platforms, currentPlatform, valid, enoughPower);
    }

    public static PacketSyncVehicleInformationToClient create(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<String> platforms = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            platforms.add(buf.m_130136_(Short.MAX_VALUE));
        }
        String currentPlatform = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
        boolean valid = buf.readBoolean();
        boolean enoughPower = buf.readBoolean();
        return new PacketSyncVehicleInformationToClient(pos, platforms, currentPlatform, valid, enoughPower);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.platforms.size());
        for (String s : this.platforms) {
            buf.m_130070_(s);
        }
        if (this.currentPlatform != null) {
            buf.writeBoolean(true);
            buf.m_130070_(this.currentPlatform);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.valid.booleanValue());
        buf.writeBoolean(this.enoughPower.booleanValue());
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity patt2481$temp = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (patt2481$temp instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)patt2481$temp;
                mover.setClientRenderInfo(this.platforms, this.currentPlatform, this.valid, this.enoughPower);
            }
        });
    }
}

