/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.tools.SequencerMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class SequencerTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    private long cycleBits = 0L;
    private int currentStep = -1;
    public static final Key<Integer> PARAM_BIT = new Key("bit", Type.INTEGER);
    public static final Key<Boolean> PARAM_CHOICE = new Key("choice", Type.BOOLEAN);
    private SequencerMode mode = SequencerMode.MODE_ONCE1;
    @GuiValue
    public static final Value<SequencerTileEntity, String> VALUE_MODE = Value.createEnum((String)"mode", (NamedEnum[])SequencerMode.values(), SequencerTileEntity::getMode, SequencerTileEntity::setMode);
    @GuiValue
    private boolean endstate = false;
    @GuiValue
    private int stepcount = 64;
    @GuiValue
    private int delay = 1;
    private boolean prevIn = false;
    private int timer = 0;
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Sequencer").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_SEQUENCER, (GenericTileEntity)this)).integerListener(Sync.integer(() -> (int)this.cycleBits, v -> this.cycleBits |= (long)v.intValue() & 0xFFFFFFFFL)).integerListener(Sync.integer(() -> (int)(this.cycleBits >> 32), v -> this.cycleBits |= (long)v.intValue() << 32 & 0xFFFFFFFF00000000L)).setupSync((GenericTileEntity)this));
    @ServerCommand
    public static final Command<?> CMD_FLIPBITS = Command.create((String)"sequencer.flipBits", (te, player, params) -> te.flipCycleBits());
    @ServerCommand
    public static final Command<?> CMD_CLEARBITS = Command.create((String)"sequencer.clearBits", (te, player, params) -> te.clearCycleBits());
    @ServerCommand
    public static final Command<?> CMD_SETBIT = Command.create((String)"sequencer.setBit", (te, player, params) -> te.setCycleBit((Integer)params.get(PARAM_BIT), (Boolean)params.get(PARAM_CHOICE)));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/sequencer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SequencerTileEntity::new));
    }

    public SequencerTileEntity(BlockPos pos, BlockState state) {
        super(LogicBlockModule.TYPE_SEQUENCER.get(), pos, state);
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public SequencerMode getMode() {
        return this.mode;
    }

    public void setMode(SequencerMode mode) {
        this.mode = mode;
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.m_6596_();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public boolean getCycleBit(int bit) {
        return (this.cycleBits >> bit & 1L) == 1L;
    }

    public long getCycleBits() {
        return this.cycleBits;
    }

    public void setCycleBit(int bit, boolean flag) {
        this.cycleBits = flag ? (this.cycleBits |= 1L << bit) : (this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.m_6596_();
    }

    public void flipCycleBits() {
        this.cycleBits ^= 0xFFFFFFFFFFFFFFFFL;
        this.m_6596_();
    }

    public void clearCycleBits() {
        this.cycleBits = 0L;
        this.m_6596_();
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_4;
    }

    public void tickOnServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.handlePulse();
        }
        this.m_6596_();
        --this.timer;
        if (this.timer <= 0) {
            this.timer = this.delay;
            this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput() ? 15 : 0);
            this.handleCycle(this.powerLevel > 0);
        } else if (this.timer > this.delay) {
            this.timer = this.delay;
        }
    }

    public boolean checkOutput() {
        return this.currentStep == -1 ? this.endstate : this.getCycleBit(this.currentStep);
    }

    private void handleCycle(boolean redstone) {
        switch (this.mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        switch (this.mode) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        ++this.currentStep;
        if (this.currentStep >= this.stepcount) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        ++this.currentStep;
        if (this.currentStep >= this.stepcount) {
            this.currentStep = -1;
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
        this.currentStep = tagCompound.m_128451_("step");
        this.prevIn = tagCompound.m_128471_("prevIn");
        this.timer = tagCompound.m_128451_("timer");
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        if (info.m_128441_("bits")) {
            this.cycleBits = info.m_128454_("bits");
        }
        int m = info.m_128451_("mode");
        this.mode = SequencerMode.values()[m];
        this.delay = (short)info.m_128451_("delay");
        if (this.delay == 0) {
            this.delay = 1;
        }
        this.stepcount = (short)info.m_128451_("stepCount");
        if (this.stepcount == 0) {
            this.stepcount = 64;
        }
        this.endstate = info.m_128471_("endState");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
        tagCompound.m_128405_("step", this.currentStep);
        tagCompound.m_128379_("prevIn", this.prevIn);
        tagCompound.m_128405_("timer", this.timer);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128356_("bits", this.cycleBits);
        info.m_128405_("mode", this.mode.ordinal());
        info.m_128405_("delay", this.delay);
        info.m_128405_("stepCount", this.stepcount);
        info.m_128379_("endState", this.endstate);
    }
}

