/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;

public final class FakePartData
implements IPartData {
    private static final ResourceLocation FAKE_ID = SilentGear.getId("fake");
    private static final Map<PartType, FakePartData> CACHE = new HashMap<PartType, FakePartData>();
    private final PartType type;

    public static FakePartData of(PartType type) {
        return CACHE.computeIfAbsent(type, FakePartData::new);
    }

    private FakePartData(PartType type) {
        this.type = type;
    }

    @Override
    public PartType getType() {
        return this.type;
    }

    @Override
    public GearType getGearType() {
        return GearType.ALL;
    }

    @Override
    public ResourceLocation getId() {
        return FAKE_ID;
    }

    @Override
    @Nullable
    public IGearPart get() {
        return null;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.f_41583_;
    }

    @Override
    public Collection<TraitInstance> getTraits(PartGearKey partKey, ItemStack gear) {
        return Collections.emptyList();
    }

    @Override
    public Component getDisplayName(PartType type, ItemStack gear) {
        return Component.m_237113_((String)"fake part");
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        return nbt;
    }

    @Override
    public String getModelKey() {
        return "fake_" + this.type.getName();
    }
}

