/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.silentchaos512.utils.MathUtils;

public final class InventoryUtils {
    private InventoryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Collection<Slot> createPlayerSlots(Inventory playerInventory, int startX, int startY) {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                list.add(new Slot((Container)playerInventory, x + y * 9 + 9, startX + x * 18, startY + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            list.add(new Slot((Container)playerInventory, x, 8 + x * 18, startY + 58));
        }
        return list;
    }

    public static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (a.m_41783_() == null && b.m_41783_() != null) {
            return false;
        }
        return (a.m_41783_() == null || a.m_41783_().equals((Object)b.m_41783_())) && a.areCapsCompatible((CapabilityProvider)b);
    }

    public static ItemStack firstMatch(Container inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack mergeItem(Container inventory, int slotStart, int slotEndExclusive, ItemStack stack) {
        int i;
        if (inventory == null || stack.m_41619_()) {
            return stack;
        }
        for (i = slotStart; i < slotEndExclusive && !stack.m_41619_(); ++i) {
            ItemStack inSlot = inventory.m_8020_(i);
            if (!InventoryUtils.canItemsStack(inSlot, stack)) continue;
            int amountCanFit = MathUtils.min(inSlot.m_41741_() - inSlot.m_41613_(), stack.m_41613_(), inventory.m_6893_());
            inSlot.m_41769_(amountCanFit);
            stack.m_41774_(amountCanFit);
            inventory.m_6836_(i, inSlot);
        }
        for (i = slotStart; i < slotEndExclusive && !stack.m_41619_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            int amountCanFit = MathUtils.min(stack.m_41613_(), inventory.m_6893_());
            ItemStack toInsert = stack.m_41777_();
            toInsert.m_41764_(amountCanFit);
            stack.m_41774_(amountCanFit);
            inventory.m_6836_(i, toInsert);
        }
        return stack;
    }

    public static Collection<ItemStack> mergeItems(Container inventory, int slotStart, int slotEndExclusive, Collection<ItemStack> stacks) {
        if (inventory == null && stacks.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder leftovers = ImmutableList.builder();
        for (ItemStack stack : stacks) {
            if ((stack = InventoryUtils.mergeItem(inventory, slotStart, slotEndExclusive, stack)).m_41619_()) continue;
            leftovers.add((Object)stack);
        }
        return leftovers.build();
    }
}

