/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.kubejs;

import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.compat.kubejs.AltarRecipeSchema;
import com.almostreliable.summoningrituals.compat.kubejs.SummoningEventJS;
import com.almostreliable.summoningrituals.platform.Platform;
import com.almostreliable.summoningrituals.recipe.component.RecipeOutputs;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class AlmostKube
extends KubeJSPlugin {
    private static final EventGroup GROUP = EventGroup.of((String)"Summoning Rituals".replace(" ", ""));
    private static final EventHandler START = GROUP.server("start", () -> SummoningEventJS.class).hasResult();
    private static final EventHandler COMPLETE = GROUP.server("complete", () -> SummoningEventJS.class);

    public void init() {
        AltarBlockEntity.SUMMONING_START.register((level, pos, recipe, player) -> START.post((EventJS)new SummoningEventJS(level, pos, recipe, player)).interruptFalse());
        AltarBlockEntity.SUMMONING_COMPLETE.register((level, pos, recipe, player) -> COMPLETE.post((EventJS)new SummoningEventJS(level, pos, recipe, player)).interruptFalse());
    }

    public void registerEvents() {
        GROUP.register();
    }

    public void registerBindings(BindingsEvent event) {
        if (event.getType() != ScriptType.SERVER) {
            return;
        }
        event.add("SummoningOutput", OutputWrapper.class);
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        if (type != ScriptType.SERVER) {
            return;
        }
        typeWrappers.registerSimple(RecipeOutputs.ItemOutputBuilder.class, OutputWrapper::item);
        typeWrappers.registerSimple(RecipeOutputs.MobOutputBuilder.class, OutputWrapper::mob);
    }

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        event.namespace("summoningrituals").register("altar", AltarRecipeSchema.SCHEMA);
    }

    public static final class OutputWrapper {
        private OutputWrapper() {
        }

        public static RecipeOutputs.ItemOutputBuilder item(@Nullable Object o) {
            if (o instanceof RecipeOutputs.ItemOutputBuilder) {
                RecipeOutputs.ItemOutputBuilder iob = (RecipeOutputs.ItemOutputBuilder)o;
                return iob;
            }
            ItemStack stack = ItemStackJS.of((Object)o);
            if (stack.m_41619_()) {
                ConsoleJS.SERVER.error((Object)"Empty or null ItemStack specified for SummoningOutput.item");
            }
            return new RecipeOutputs.ItemOutputBuilder(stack);
        }

        public static RecipeOutputs.MobOutputBuilder mob(@Nullable Object o) {
            if (o instanceof RecipeOutputs.MobOutputBuilder) {
                RecipeOutputs.MobOutputBuilder mob = (RecipeOutputs.MobOutputBuilder)o;
                return mob;
            }
            if (o instanceof CharSequence || o instanceof ResourceLocation) {
                ResourceLocation id = ResourceLocation.m_135820_((String)o.toString());
                EntityType<?> mob = Platform.mobFromId(id);
                return new RecipeOutputs.MobOutputBuilder(mob);
            }
            ConsoleJS.SERVER.error((Object)"Missing or invalid entity specified for SummoningOutput.mob");
            return new RecipeOutputs.MobOutputBuilder(EntityType.f_20461_);
        }
    }
}

