/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.component;

import com.almostreliable.summoningrituals.platform.Platform;
import com.almostreliable.summoningrituals.util.MathUtils;
import com.almostreliable.summoningrituals.util.SerializeUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import extensions.net.minecraft.world.entity.Entity.EntityExt;
import extensions.net.minecraft.world.entity.item.ItemEntity.ItemEntityExt;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;

public final class RecipeOutputs {
    private static final Vec3i DEFAULT_OFFSET = new Vec3i(0, 2, 0);
    private static final Vec3i DEFAULT_SPREAD = new Vec3i(1, 0, 1);
    private static final Random RANDOM = new Random();
    private final NonNullList<RecipeOutput<?>> outputs;

    private RecipeOutputs(NonNullList<RecipeOutput<?>> outputs) {
        this.outputs = outputs;
    }

    public RecipeOutputs() {
        this(NonNullList.m_122779_());
    }

    public static RecipeOutputs fromJson(JsonArray json) {
        NonNullList recipeOutputs = NonNullList.m_122779_();
        for (JsonElement output : json) {
            recipeOutputs.add(RecipeOutput.fromJson(output.getAsJsonObject()));
        }
        return new RecipeOutputs(recipeOutputs);
    }

    public static RecipeOutputs fromNetwork(FriendlyByteBuf buffer) {
        int length = buffer.m_130242_();
        NonNullList outputs = NonNullList.m_122779_();
        for (int i = 0; i < length; ++i) {
            outputs.add(RecipeOutput.fromNetwork(buffer));
        }
        return new RecipeOutputs(outputs);
    }

    public JsonArray toJson() {
        JsonArray json = new JsonArray();
        for (RecipeOutput output : this.outputs) {
            json.add((JsonElement)output.toJson());
        }
        return json;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.outputs.size());
        for (RecipeOutput output : this.outputs) {
            output.toNetwork(buffer);
        }
    }

    public void add(RecipeOutput<?> output) {
        this.outputs.add(output);
    }

    public void handleRecipe(ServerLevel level, BlockPos origin) {
        for (RecipeOutput output : this.outputs) {
            output.spawn(level, origin);
        }
    }

    public int size() {
        return this.outputs.size();
    }

    public void forEach(TriConsumer<OutputType, RecipeOutput<?>, Integer> consumer) {
        for (int i = 0; i < this.outputs.size(); ++i) {
            RecipeOutput output = (RecipeOutput)this.outputs.get(i);
            consumer.accept((Object)output.type, (Object)output, (Object)i);
        }
    }

    public static abstract class RecipeOutput<T> {
        private final OutputType type;
        protected final T output;
        protected CompoundTag data;
        protected Vec3i offset = DEFAULT_OFFSET;
        protected Vec3i spread = DEFAULT_SPREAD;

        private RecipeOutput(OutputType type, T output) {
            this.type = type;
            this.output = output;
            this.data = new CompoundTag();
        }

        private static RecipeOutput<?> fromJson(JsonObject json) {
            RecipeOutput output;
            if (json.has("item")) {
                output = ItemOutput.fromJson(json);
            } else if (json.has("mob")) {
                output = MobOutput.fromJson(json);
            } else {
                throw new IllegalArgumentException("Invalid recipe output");
            }
            if (json.has("data")) {
                output.data = SerializeUtils.nbtFromString(GsonHelper.m_13906_((JsonObject)json, (String)"data"));
            }
            if (json.has("offset")) {
                output.offset = SerializeUtils.vec3FromJson(json.getAsJsonObject("offset"));
            }
            if (json.has("spread")) {
                output.spread = SerializeUtils.vec3FromJson(json.getAsJsonObject("spread"));
            }
            return output;
        }

        private static RecipeOutput<?> fromNetwork(FriendlyByteBuf buffer) {
            RecipeOutput output;
            int i = buffer.m_130242_();
            if (i == 0) {
                output = ItemOutput.fromNetwork(buffer);
            } else if (i == 1) {
                output = MobOutput.fromNetwork(buffer);
            } else {
                throw new IllegalArgumentException("Invalid recipe output");
            }
            if (buffer.readBoolean()) {
                output.data = buffer.m_130260_();
            }
            output.offset = SerializeUtils.vec3FromNetwork(buffer);
            output.spread = SerializeUtils.vec3FromNetwork(buffer);
            return output;
        }

        abstract JsonObject toJson();

        void writeJsonDefaults(JsonObject json) {
            if (!this.data.m_128456_()) {
                json.addProperty("data", this.data.toString());
            }
            if (!this.offset.equals((Object)DEFAULT_OFFSET)) {
                json.add("offset", (JsonElement)SerializeUtils.vec3ToJson(this.offset));
            }
            if (!this.spread.equals((Object)DEFAULT_SPREAD)) {
                json.add("spread", (JsonElement)SerializeUtils.vec3ToJson(this.spread));
            }
        }

        void toNetwork(FriendlyByteBuf buffer) {
            if (this.data.m_128456_()) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.m_130079_(this.data);
            }
            SerializeUtils.vec3ToNetwork(buffer, this.offset);
            SerializeUtils.vec3ToNetwork(buffer, this.spread);
        }

        Entity writeDataToEntity(Entity entity) {
            if (this.data.m_128456_()) {
                return entity;
            }
            CompoundTag entityData = Platform.serializeEntity(entity);
            for (String prop : this.data.m_128431_()) {
                entityData.m_128365_(prop, Objects.requireNonNull(this.data.m_128423_(prop)));
            }
            entity.m_20258_(entityData);
            return entity;
        }

        Vec3 getRandomPos(BlockPos origin) {
            double x = this.spread.m_123341_() > 0 ? RANDOM.nextDouble(-this.spread.m_123341_(), this.spread.m_123341_()) / 2.0 : 0.0;
            double y = this.spread.m_123342_() > 0 ? RANDOM.nextDouble(-this.spread.m_123342_(), this.spread.m_123342_()) / 2.0 : 0.0;
            double z = this.spread.m_123343_() > 0 ? RANDOM.nextDouble(-this.spread.m_123343_(), this.spread.m_123343_()) / 2.0 : 0.0;
            return MathUtils.shiftToCenter((Vec3i)origin).m_82549_(MathUtils.vectorFromPos(this.offset)).m_82520_(x, y, z);
        }

        abstract void spawn(ServerLevel var1, BlockPos var2);

        public T getOutput() {
            return this.output;
        }

        public abstract int getCount();

        public CompoundTag getData() {
            return this.data;
        }
    }

    public static enum OutputType {
        ITEM,
        MOB;

    }

    public static class MobOutputBuilder
    extends RecipeOutputBuilder {
        private EntityType<?> mob;
        private int count;

        public MobOutputBuilder(EntityType<?> mob) {
            this.mob = mob;
            this.count = 1;
        }

        public MobOutputBuilder mob(EntityType<?> mob) {
            this.mob = mob;
            return this;
        }

        public MobOutputBuilder count(int count) {
            this.count = count;
            return this;
        }

        public MobOutput build() {
            MobOutput output = new MobOutput(this.mob, this.count);
            output.data = this.data;
            output.offset = this.offset;
            output.spread = this.spread;
            return output;
        }
    }

    public static class ItemOutputBuilder
    extends RecipeOutputBuilder {
        private ItemStack stack;

        public ItemOutputBuilder(ItemStack stack) {
            this.stack = stack;
        }

        public ItemOutputBuilder item(ItemStack item) {
            this.stack = item;
            return this;
        }

        public ItemOutput build() {
            ItemOutput output = new ItemOutput(this.stack);
            output.data = this.data;
            output.offset = this.offset;
            output.spread = this.spread;
            return output;
        }
    }

    private static abstract class RecipeOutputBuilder {
        CompoundTag data = new CompoundTag();
        Vec3i offset = new Vec3i(0, 2, 0);
        Vec3i spread = new Vec3i(1, 0, 1);

        private RecipeOutputBuilder() {
        }

        public abstract RecipeOutput<?> build();

        public RecipeOutputBuilder data(CompoundTag data) {
            this.data = data;
            return this;
        }

        public RecipeOutputBuilder offset(int x, int y, int z) {
            this.offset = new Vec3i(x, y, z);
            return this;
        }

        public RecipeOutputBuilder spread(int x, int y, int z) {
            this.spread = new Vec3i(x, y, z);
            return this;
        }
    }

    private static final class MobOutput
    extends RecipeOutput<EntityType<?>> {
        private final int mobCount;

        private MobOutput(EntityType<?> mob, int mobCount) {
            super(OutputType.MOB, mob);
            this.mobCount = mobCount;
        }

        private static MobOutput fromJson(JsonObject json) {
            EntityType<?> mob = Platform.mobFromJson(json);
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new MobOutput(mob, count);
        }

        private static MobOutput fromNetwork(FriendlyByteBuf buffer) {
            EntityType<?> mob = SerializeUtils.mobFromNetwork(buffer);
            int count = buffer.m_130242_();
            return new MobOutput(mob, count);
        }

        @Override
        JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("mob", Platform.getId((EntityType)this.output).toString());
            if (this.mobCount > 1) {
                json.addProperty("count", (Number)this.mobCount);
            }
            this.writeJsonDefaults(json);
            return json;
        }

        @Override
        void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130130_(1);
            buffer.m_130070_(Platform.getId((EntityType)this.output).toString());
            buffer.m_130130_(this.mobCount);
            super.toNetwork(buffer);
        }

        @Override
        void spawn(ServerLevel level, BlockPos origin) {
            for (int i = 0; i < this.mobCount; ++i) {
                Entity mobEntity = ((EntityType)this.output).m_20615_((Level)level);
                if (mobEntity == null) {
                    return;
                }
                EntityExt.spawn(mobEntity, (Level)level, this.getRandomPos(origin), this::writeDataToEntity);
            }
        }

        @Override
        public int getCount() {
            return this.mobCount;
        }
    }

    private static final class ItemOutput
    extends RecipeOutput<ItemStack> {
        private ItemOutput(ItemStack stack) {
            super(OutputType.ITEM, stack);
        }

        private static ItemOutput fromJson(JsonObject json) {
            ItemStack stack = Platform.itemStackFromJson(json);
            return new ItemOutput(stack);
        }

        private static ItemOutput fromNetwork(FriendlyByteBuf buffer) {
            return new ItemOutput(buffer.m_130267_());
        }

        @Override
        JsonObject toJson() {
            JsonObject json = SerializeUtils.stackToJson((ItemStack)this.output);
            this.writeJsonDefaults(json);
            return json;
        }

        @Override
        void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130130_(0);
            buffer.m_130055_((ItemStack)this.output);
            super.toNetwork(buffer);
        }

        @Override
        void spawn(ServerLevel level, BlockPos origin) {
            ItemStack stack;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int toSpawn = this.getCount(); toSpawn > 0; toSpawn -= stack.m_41613_()) {
                stack = ((ItemStack)this.output).m_255036_(Math.min(toSpawn, 4));
                stacks.add(stack);
            }
            for (ItemStack stack2 : stacks) {
                EntityExt.spawn((Entity)ItemEntityExt.of((Level)level, stack2), (Level)level, this.getRandomPos(origin), this::writeDataToEntity);
            }
        }

        @Override
        public int getCount() {
            return ((ItemStack)this.output).m_41613_();
        }
    }
}

