/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.dispenser;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SackBlock;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BambooSpikesBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BombsBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BucketBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.EmptyBundleItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.EmptyContainerItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FakePlayerUseItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FireBehaviorProxy;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FishBucketJarBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FlintAndSteelBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.GunpowderBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.KeyBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.PancakeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableBricksBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableEnderPearlBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableSlimeballBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.PopperBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.items.DispenserMinecartItem;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DispenserBehaviorsManager {
    public static void init() {
        RegHelper.addDynamicDispenserBehaviorRegistration(DispenserBehaviorsManager::registerBehaviors);
    }

    public static void registerBehaviors(DispenserHelper.Event event) {
        boolean isForge = PlatHelper.getPlatform().isForge();
        if (!CommonConfigs.General.DISPENSERS.get().booleanValue()) {
            return;
        }
        if (CommonConfigs.Tweaks.BUNDLE_DISPENSER.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new EmptyBundleItemBehavior(Items.f_151058_));
            event.register((DispenserHelper.AdditionalDispenserBehavior)new EmptyContainerItemBehavior(ModRegistry.LUNCH_BASKET_ITEM.get()));
            event.register((DispenserHelper.AdditionalDispenserBehavior)new EmptyContainerItemBehavior(ModRegistry.QUIVER_ITEM.get()));
        }
        if (CommonConfigs.Tweaks.ENDER_PEAR_DISPENSERS.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new ThrowableEnderPearlBehavior());
        }
        if (CommonConfigs.Redstone.DISPENSER_MINECART_ENABLED.get().booleanValue()) {
            event.register(ModRegistry.DISPENSER_MINECART_ITEM.get(), DispenserMinecartItem.DISPENSE_ITEM_BEHAVIOR);
        }
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue()) {
            OptionalDispenseItemBehavior armorBehavior = new OptionalDispenseItemBehavior(){

                protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            event.register(ModRegistry.ENDERMAN_SKULL_ITEM.get(), (DispenseItemBehavior)armorBehavior);
        }
        if (CommonConfigs.Functional.FODDER_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.FODDER.get());
        }
        if (CommonConfigs.Tools.LUNCH_BOX_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.LUNCH_BASKET.get());
        }
        if (CommonConfigs.Functional.SOAP_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.BUBBLE_BLOCK.get());
        }
        if (CommonConfigs.Functional.SACK_ENABLED.get().booleanValue()) {
            for (Block s : SackBlock.SACK_BLOCKS) {
                event.registerPlaceBlock((ItemLike)s);
            }
        }
        if (CommonConfigs.Functional.LUMISENE_ENABLED.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new BucketBehavior(ModFluids.LUMISENE_BUCKET.get()));
        }
        if (CommonConfigs.Functional.JAR_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.JAR_ITEM.get());
            event.register((DispenserHelper.AdditionalDispenserBehavior)new DispenserHelper.AddItemToInventoryBehavior(Items.f_42572_));
        }
        event.register((DispenserHelper.AdditionalDispenserBehavior)new FlintAndSteelBehavior(Items.f_42409_));
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.BAMBOO_SPIKES_ITEM.get());
        }
        if (CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue()) {
            event.registerPlaceBlock((ItemLike)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get());
            event.register((DispenserHelper.AdditionalDispenserBehavior)new BambooSpikesBehavior(Items.f_42739_));
        }
        if (isForge) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(ModRegistry.SOAP.get()));
        }
        if (CommonConfigs.Tools.POPPER_ENABLED.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new FireBehaviorProxy(ModRegistry.CONFETTI_POPPER.get(), new PopperBehavior(), 0.7f, 1, false));
        }
        if (CommonConfigs.Tweaks.THROWABLE_BRICKS_ENABLED.get().booleanValue()) {
            BuiltInRegistries.f_257033_.m_206058_(ModTags.BRICKS).iterator().forEachRemaining(h -> event.register((DispenserHelper.AdditionalDispenserBehavior)new ThrowableBricksBehavior((Item)h.m_203334_())));
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            BombsBehavior bombBehavior = new BombsBehavior();
            event.register(ModRegistry.BOMB_ITEM.get(), (DispenseItemBehavior)bombBehavior);
            event.register(ModRegistry.BOMB_ITEM_ON.get(), (DispenseItemBehavior)bombBehavior);
            event.register(ModRegistry.BOMB_BLUE_ITEM.get(), (DispenseItemBehavior)bombBehavior);
            event.register(ModRegistry.BOMB_BLUE_ITEM_ON.get(), (DispenseItemBehavior)bombBehavior);
            event.register(ModRegistry.BOMB_SPIKY_ITEM.get(), (DispenseItemBehavior)bombBehavior);
            event.register(ModRegistry.BOMB_SPIKY_ITEM_ON.get(), (DispenseItemBehavior)bombBehavior);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            event.register((DispenserHelper.AdditionalDispenserBehavior)new GunpowderBehavior(Items.f_42403_));
        }
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            event.register(ModRegistry.ROPE_ARROW_ITEM.get(), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                    CompoundTag com = stack.m_41783_();
                    int charges = stack.m_41776_();
                    if (com != null && com.m_128441_("Damage")) {
                        charges -= com.m_128451_("Damage");
                    }
                    RopeArrowEntity arrow = new RopeArrowEntity(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), charges);
                    arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    return arrow;
                }
            });
        }
        boolean axe = CommonConfigs.Tweaks.AXE_DISPENSER_BEHAVIORS.get();
        boolean jar = CommonConfigs.Functional.JAR_ENABLED.get();
        boolean key = CommonConfigs.isEnabled("key");
        boolean slimeball = CommonConfigs.isEnabled("key");
        boolean pancake = CommonConfigs.isEnabled("pancake");
        if (axe || jar || key) {
            for (Item i : BuiltInRegistries.f_257033_) {
                try {
                    if (jar && BucketHelper.isFishBucket(i)) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new FishBucketJarBehavior(i));
                    }
                    if (pancake && ModBlockProperties.Topping.fromItem(i).getFirst() != ModBlockProperties.Topping.NONE) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new PancakeBehavior(i));
                    }
                    if (isForge && axe && i instanceof AxeItem) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(i));
                    }
                    if (key && i instanceof KeyItem) {
                        event.register((DispenserHelper.AdditionalDispenserBehavior)new KeyBehavior(i));
                    }
                    if (!slimeball || !SuppPlatformStuff.isSlimeball(i)) continue;
                    event.register((DispenserHelper.AdditionalDispenserBehavior)new ThrowableSlimeballBehavior(i));
                }
                catch (Exception e) {
                    Supplementaries.error();
                    Supplementaries.LOGGER.warn("Error white registering dispenser behavior for item {}: {}", (Object)i, (Object)e);
                }
            }
        }
    }
}

