/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public record StarItemListing(ItemStack emeralds, ItemStack priceSecondary, int stars, int maxTrades, int xp, float priceMult, int level) implements ModItemListing
{
    public static final Codec<StarItemListing> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("price").forGetter(StarItemListing::emeralds), (App)StrOpt.of((Codec)ItemStack.f_41582_, (String)"price_secondary", (Object)ItemStack.f_41583_).forGetter(StarItemListing::priceSecondary), (App)Codec.INT.fieldOf("amount").forGetter(StarItemListing::stars), (App)StrOpt.of((Codec)ExtraCodecs.f_144629_, (String)"max_trades", (Object)16).forGetter(StarItemListing::maxTrades), (App)StrOpt.of((Codec)ExtraCodecs.f_144629_, (String)"xp").forGetter(s -> Optional.of(s.xp)), (App)StrOpt.of((Codec)ExtraCodecs.f_184349_, (String)"price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(StarItemListing::priceMult), (App)StrOpt.of((Codec)Codec.intRange((int)1, (int)5), (String)"level", (Object)1).forGetter(StarItemListing::level)).apply((Applicative)instance, StarItemListing::createDefault));
    private static final DyeColor[] VIBRANT_COLORS = new DyeColor[]{DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.GREEN, DyeColor.RED};

    public static StarItemListing createDefault(ItemStack price, ItemStack price2, int rockets, int maxTrades, Optional<Integer> xp, float priceMult, int level) {
        return new StarItemListing(price, price2, rockets, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)false, (int)level)), priceMult, level);
    }

    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
        ItemStack star = new ItemStack((ItemLike)Items.f_42689_, this.stars);
        star.m_41700_("Explosion", (Tag)StarItemListing.createRandomFireworkStar(random, List.of()));
        return new MerchantOffer(this.emeralds, this.priceSecondary, star, this.maxTrades, this.xp, this.priceMult);
    }

    public int getLevel() {
        return this.level;
    }

    public Codec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    public static CompoundTag createRandomFireworkStar(RandomSource random, List<FireworkRocketItem.Shape> usedShapes) {
        CompoundTag tag = new CompoundTag();
        ArrayList<FireworkRocketItem.Shape> possible = new ArrayList<FireworkRocketItem.Shape>(List.of(FireworkRocketItem.Shape.values()));
        possible.removeAll(usedShapes);
        if (possible.isEmpty()) {
            tag.m_128344_("Type", (byte)FireworkRocketItem.Shape.values()[random.m_188503_(FireworkRocketItem.Shape.values().length)].m_41236_());
        } else {
            tag.m_128344_("Type", (byte)possible.get(random.m_188503_(possible.size())).m_41236_());
        }
        tag.m_128379_("Flicker", random.m_188501_() < 0.42f);
        tag.m_128379_("Trail", random.m_188501_() < 0.42f);
        IntArrayList list = new IntArrayList();
        int colors = 0;
        do {
            list.add(VIBRANT_COLORS[random.m_188503_(VIBRANT_COLORS.length)].m_41070_());
        } while (random.m_188501_() < 0.42f && ++colors < 9);
        tag.m_128408_("Colors", (List)list);
        if (random.m_188499_()) {
            IntArrayList fadeList = new IntArrayList();
            colors = 0;
            do {
                fadeList.add(VIBRANT_COLORS[random.m_188503_(VIBRANT_COLORS.length)].m_41070_());
            } while (random.m_188501_() < 0.42f && ++colors < 9);
            tag.m_128408_("FadeColors", (List)fadeList);
        }
        return tag;
    }
}

