/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.forge;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.hud.forge.CannonChargeHudImpl;
import net.mehvahdjukaar.supplementaries.client.hud.forge.SelectableContainerItemHudImpl;
import net.mehvahdjukaar.supplementaries.client.hud.forge.SlimedOverlayHudImpl;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredHeadLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.PartyHatLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.QuiverLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.SlimedLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.AltimeterItemRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="supplementaries", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SupplementariesForgeClient {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        VibeChecker.checkVibe();
    }

    @SubscribeEvent
    public static void onRegisterSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel(EndermanSkullBlock.TYPE, (SkullModelBase)new SkullModel(event.getEntityModelSet().m_171103_(ModelLayers.f_171240_)));
        SkullBlockRenderer.f_112519_.put(EndermanSkullBlock.TYPE, Supplementaries.res("textures/entity/enderman_head.png"));
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        for (String skinType : event.getSkins()) {
            LivingEntityRenderer renderer = event.getSkin(skinType);
            if (renderer == null) continue;
            renderer.m_115326_(new QuiverLayer(renderer, false));
            LivingEntityRenderer model = renderer;
            renderer.m_115326_(new JarredHeadLayer(model, event.getEntityModels()));
            renderer.m_115326_(new PartyHatLayer.Generic(model, event.getEntityModels()));
        }
        try {
            LivingEntityRenderer skeletonRenderer = event.getRenderer(EntityType.f_20524_);
            if (skeletonRenderer != null) {
                skeletonRenderer.m_115326_(new QuiverLayer(skeletonRenderer, true));
            }
        }
        catch (Exception e2) {
            Supplementaries.LOGGER.warn("Failed to add quiver layer to skeleton. This bug was caused by forge! Use neo");
        }
        try {
            LivingEntityRenderer strayRenderer = event.getRenderer(EntityType.f_20481_);
            if (strayRenderer != null) {
                strayRenderer.m_115326_(new QuiverLayer(strayRenderer, true));
            }
        }
        catch (Exception e3) {
            Supplementaries.LOGGER.warn("Failed to add quiver layer to stray. This bug was caused by forge! Use neo");
        }
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(DefaultAttributes::m_22301_).filter(e -> e != EntityType.f_20565_).map(entityType -> entityType).collect(Collectors.toList()));
        entityTypes.forEach(entityType -> {
            try {
                LivingEntityRenderer r = event.getRenderer(entityType);
                if (r != null && !(r instanceof NoopRenderer)) {
                    r.m_115326_(new SlimedLayer(r));
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("Failed to add slimed layer to entity: " + String.valueOf(entityType));
            }
        });
        try {
            LivingEntityRenderer creeperRenderer = event.getRenderer(EntityType.f_20558_);
            if (creeperRenderer != null) {
                creeperRenderer.m_115326_(new PartyHatLayer.Creeper(creeperRenderer, event.getEntityModels(), event.getContext().m_234598_()));
            }
        }
        catch (Exception e4) {
            Supplementaries.LOGGER.warn("Failed to add party hat layer to creeper. This bug was caused by forge! Use neo");
        }
        for (String skinType : event.getSkins()) {
            LivingEntityRenderer r = event.getSkin(skinType);
            if (r == null) continue;
            r.m_115326_(new SlimedLayer(r));
        }
    }

    @SubscribeEvent
    public static void onPackReload(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            AltimeterItemRenderer.onReload();
        }
    }

    @SubscribeEvent
    public static void onAddGuiLayers(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "quiver_overlay", (IGuiOverlay)((SelectableContainerItemHudImpl)SelectableContainerItemHudImpl.INSTANCE));
        event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "cannon_charge_overlay", (IGuiOverlay)new CannonChargeHudImpl());
        event.registerBelow(VanillaGuiOverlay.FROSTBITE.id(), "slimed_overlay", (IGuiOverlay)new SlimedOverlayHudImpl());
    }
}

